/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.builds;

import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.meta.inputs.Input;
import scala.meta.internal.builds.SbtBuildTool;
import scala.meta.internal.builds.SbtBuildTool$PluginDetails$;
import scala.meta.internal.metals.AdjustLspData;
import scala.meta.internal.metals.AdjustedLspData$;
import scala.meta.internal.metals.BuildInfo$;
import scala.meta.internal.metals.JavaBinary$;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.UserConfiguration;
import scala.meta.io.AbsolutePath;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scribe.data.MDC$;
import scribe.message.LoggableMessage;
import scribe.message.LoggableMessage$;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;
import ujson.Readable;
import ujson.Readable$;
import ujson.Value;
import ujson.package$;

public final class SbtBuildTool$
implements Serializable {
    public static final SbtBuildTool$ MODULE$ = new SbtBuildTool$();
    private static final String name = "sbt";
    private static final String firstVersionWithBsp = "1.4.1";

    public String name() {
        return name;
    }

    public String firstVersionWithBsp() {
        return firstVersionWithBsp;
    }

    public boolean writePlugins(AbsolutePath projectDir, Seq<SbtBuildTool.PluginDetails> plugins) {
        String content = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(81).append("|// DO NOT EDIT! This file is auto-generated.\n          |\n          |").append(((IterableOnceOps)plugins.map((Function1 & Serializable)plugin -> MODULE$.sbtPlugin((SbtBuildTool.PluginDetails)plugin))).mkString("\n")).append("\n          |").toString()));
        byte[] bytes = content.getBytes(StandardCharsets.UTF_8);
        projectDir.toFile().mkdirs();
        AbsolutePath metalsPluginFile = projectDir.resolve("metals.sbt");
        boolean pluginFileShouldChange = !metalsPluginFile.isFile() || !Predef$.MODULE$.wrapByteArray(metalsPluginFile.readAllBytes()).sameElements((IterableOnce)Predef$.MODULE$.wrapByteArray(bytes));
        Object object = pluginFileShouldChange ? Files.write(metalsPluginFile.toNIO(), bytes, new OpenOption[0]) : BoxedUnit.UNIT;
        return pluginFileShouldChange;
    }

    public boolean writeSbtMetalsPlugins(AbsolutePath workspace) {
        AbsolutePath mainMeta = workspace.resolve("project");
        AbsolutePath metaMeta = workspace.resolve("project").resolve("project");
        boolean writtenPlugin = this.writePlugins(mainMeta, (Seq<SbtBuildTool.PluginDetails>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SbtBuildTool.PluginDetails[]{this.metalsPluginDetails(), this.debugAdapterPluginDetails()}));
        boolean writtenMeta = this.writePlugins(metaMeta, (Seq<SbtBuildTool.PluginDetails>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SbtBuildTool.PluginDetails[]{this.metalsPluginDetails(), this.jdiToolsPluginDetails()}));
        return writtenPlugin || writtenMeta;
    }

    private Option<String> sonatypeResolver(String version) {
        if (version.contains("SNAPSHOT")) {
            return new Some((Object)"resolvers += \"Sonatype OSS Snapshots\" at \"https://oss.sonatype.org/content/repositories/snapshots\"");
        }
        return None$.MODULE$;
    }

    public SbtBuildTool.PluginDetails scala$meta$internal$builds$SbtBuildTool$$bloopPluginDetails(String version) {
        return SbtBuildTool$PluginDetails$.MODULE$.apply((Seq<String>)new .colon.colon((Object)"This file enables sbt-bloop to create bloop config files.", (List)Nil$.MODULE$), new StringBuilder(34).append("\"ch.epfl.scala\" % \"sbt-bloop\" % \"").append(version).append("\"").toString(), this.sonatypeResolver(version));
    }

    private SbtBuildTool.PluginDetails metalsPluginDetails() {
        return SbtBuildTool$PluginDetails$.MODULE$.apply((Seq<String>)new .colon.colon((Object)"This plugin enables semantic information to be produced by sbt.", (List)new .colon.colon((Object)"It also adds support for debugging using the Debug Adapter Protocol", (List)Nil$.MODULE$)), new StringBuilder(35).append("\"org.scalameta\" % \"sbt-metals\" % \"").append(BuildInfo$.MODULE$.metalsVersion()).append("\"").toString(), this.sonatypeResolver(BuildInfo$.MODULE$.metalsVersion()));
    }

    private SbtBuildTool.PluginDetails debugAdapterPluginDetails() {
        return SbtBuildTool$PluginDetails$.MODULE$.apply((Seq<String>)new .colon.colon((Object)"This plugin adds the BSP debug capability to sbt server.", (List)Nil$.MODULE$), new StringBuilder(42).append("\"ch.epfl.scala\" % \"sbt-debug-adapter\" % \"").append(BuildInfo$.MODULE$.debugAdapterVersion()).append("\"").toString(), (Option<String>)None$.MODULE$);
    }

    private SbtBuildTool.PluginDetails jdiToolsPluginDetails() {
        return SbtBuildTool$PluginDetails$.MODULE$.apply((Seq<String>)new .colon.colon((Object)"This plugin makes sure that the JDI tools are in the sbt classpath.", (List)new .colon.colon((Object)"JDI tools are used by the debug adapter server.", (List)Nil$.MODULE$)), new StringBuilder(43).append("\"org.scala-debugger\" % \"sbt-jdi-tools\" % \"").append(BuildInfo$.MODULE$.sbtJdiToolsVersion()).append("\"").toString(), (Option<String>)None$.MODULE$);
    }

    private String sbtPlugin(SbtBuildTool.PluginDetails plugin) {
        String resolvers = (String)plugin.resolver().getOrElse((Function0 & Serializable)() -> "");
        String description = plugin.description().mkString("// ", "\n// ", "");
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(45).append("|").append(description).append("\n        |").append(resolvers).append("\n        |addSbtPlugin(").append(plugin.artifact()).append(")\n        |").toString()));
    }

    public boolean isSbtRelatedPath(AbsolutePath workspace, AbsolutePath path2) {
        String filename;
        Path project = workspace.toNIO().resolve("project");
        Set isToplevel = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Path[]{workspace.toNIO(), project, project.resolve("project")}));
        return isToplevel.apply((Object)path2.toNIO().getParent()) && ((filename = ((Object)path2.toNIO().getFileName()).toString()).endsWith("build.properties") || filename.endsWith(".sbt") || filename.endsWith(".scala"));
    }

    public SbtBuildTool apply(AbsolutePath workspace, Function0<UserConfiguration> userConfig) {
        Option version = this.loadVersion(workspace).map((Function1 & Serializable)x$1 -> x$1.toString());
        return new SbtBuildTool((Option<String>)version, userConfig);
    }

    public Option<String> loadVersion(AbsolutePath workspace) {
        Properties props = new Properties();
        AbsolutePath buildproperties = workspace.resolve("project").resolve("build.properties");
        if (!buildproperties.isFile()) {
            return None$.MODULE$;
        }
        try (InputStream in = Files.newInputStream(buildproperties.toNIO(), new OpenOption[0]);){
            props.load(in);
        }
        return Option$.MODULE$.apply((Object)props.getProperty("sbt.version"));
    }

    public Tuple3<Input.VirtualFile, Function1<Position, Position>, AdjustLspData> sbtInputPosAdjustment(Input.VirtualFile originInput, Seq<String> autoImports) {
        int appendLineSize = autoImports.size();
        String x$1 = this.prependAutoImports(originInput.value(), autoImports);
        String x$2 = originInput.copy$default$1();
        Input.VirtualFile modifiedInput = originInput.copy(x$2, x$1);
        AdjustLspData adjustLspData = AdjustedLspData$.MODULE$.create((Function1<Position, Position>)(Function1 & Serializable)pos -> new Position(pos.getLine() - appendLineSize, pos.getCharacter()), (Function1<Location, Object>)(Function1 & Serializable)loc -> BoxesRunTime.boxToBoolean((boolean)SbtBuildTool$.$anonfun$sbtInputPosAdjustment$2(loc)));
        return new Tuple3((Object)modifiedInput, (Function1 & Serializable)position -> SbtBuildTool$.adjustRequest$1(position, appendLineSize), (Object)adjustLspData);
    }

    public String prependAutoImports(String text, Seq<String> autoImports) {
        String prepend = autoImports.mkString("", "\n", "\n");
        return new StringBuilder(0).append(prepend).append(text).toString();
    }

    public boolean checkCorrectJavaVersion(AbsolutePath workspace, Option<String> userJavaHome) {
        AbsolutePath bspConfigFile = workspace.resolve(".bsp").resolve("sbt.json");
        if (bspConfigFile.isFile()) {
            Option matchesSbtJavaHome = MetalsEnrichments$.MODULE$.XtensionAbsolutePath(bspConfigFile).readTextOpt().map((Function1 & Serializable)text -> {
                Value json = package$.MODULE$.read((Readable)Readable$.MODULE$.fromString(text), package$.MODULE$.read$default$2());
                return new Tuple2(text, (Object)json);
            }).flatMap((Function1 & Serializable)x$3 -> {
                Tuple2 tuple2 = x$3;
                if (tuple2 != null) {
                    Value json = (Value)tuple2._2();
                    return json.apply((Value.Selector)Value.Selector$.MODULE$.StringSelector("argv")).arrOpt().flatMap((Function1 & Serializable)args -> args.headOption().flatMap((Function1 & Serializable)firstArg -> firstArg.strOpt().withFilter((Function1 & Serializable)javaArg -> BoxesRunTime.boxToBoolean((boolean)javaArg.endsWith("java"))).map((Function1 & Serializable)javaArg -> BoxesRunTime.boxToBoolean((boolean)SbtBuildTool$.$anonfun$checkCorrectJavaVersion$6(userJavaHome, javaArg)))));
                }
                throw new MatchError((Object)tuple2);
            });
            return BoxesRunTime.unboxToBoolean((Object)matchesSbtJavaHome.getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> true));
        }
        return true;
    }

    public SbtBuildTool apply(Option<String> workspaceVersion, Function0<UserConfiguration> userConfig) {
        return new SbtBuildTool(workspaceVersion, userConfig);
    }

    public Option<Tuple2<Option<String>, Function0<UserConfiguration>>> unapply(SbtBuildTool x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2(x$0.workspaceVersion(), x$0.userConfig()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SbtBuildTool$.class);
    }

    private static final Position adjustRequest$1(Position position, int appendLineSize$1) {
        return new Position(appendLineSize$1 + position.getLine(), position.getCharacter());
    }

    public static final /* synthetic */ boolean $anonfun$sbtInputPosAdjustment$2(Location loc) {
        return !MetalsEnrichments$.MODULE$.XtensionStringDoc(loc.getUri()).isSbt();
    }

    public static final /* synthetic */ boolean $anonfun$checkCorrectJavaVersion$7(String javaArg$1, AbsolutePath x$2) {
        String string = x$2.toString();
        String string2 = javaArg$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$checkCorrectJavaVersion$6(Option userJavaHome$1, String javaArg) {
        List<AbsolutePath> possibleJavaBinaries = JavaBinary$.MODULE$.allPossibleJavaBinaries((Option<String>)userJavaHome$1);
        boolean sbtJavaHomeIsCorrect = possibleJavaBinaries.exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SbtBuildTool$.$anonfun$checkCorrectJavaVersion$7(javaArg, x$2)));
        Object object = !sbtJavaHomeIsCorrect ? scribe.package$.MODULE$.debug((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LoggableMessage[]{LoggableMessage$.MODULE$.string2Message((Function0 & Serializable)() -> new StringBuilder(97).append("Java binary used by sbt server ").append(javaArg).append(" doesn't match the expected java home. Possible paths considered: ").append(possibleJavaBinaries).toString())}), new Pkg("scala.meta.internal.builds"), new FileName("SbtBuildTool.scala"), new Name("matchesSbtJavaHome"), new Line(427), MDC$.MODULE$.global()) : BoxedUnit.UNIT;
        return sbtJavaHomeIsCorrect;
    }

    private SbtBuildTool$() {
    }
}

