/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import java.io.Serializable;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.zip.ZipError;
import java.util.zip.ZipException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.mutable.Builder;
import scala.math.Numeric;
import scala.meta.internal.io.PlatformFileIO$;
import scala.meta.internal.metals.JdbcEnrichments$;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.mtags.MD5$;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005\r4A\u0001C\u0005\u0003%!Aq\u0003\u0001B\u0001B\u0003%\u0001\u0004C\u0003$\u0001\u0011\u0005A\u0005C\u0003)\u0001\u0011\u0005\u0011\u0006C\u0003M\u0001\u0011\u0005Q\nC\u0003U\u0001\u0011\u0005Q\u000bC\u0003\\\u0001\u0011%A\fC\u0003_\u0001\u0011\u0005qL\u0001\u0007KCJ$v\u000e\u001d'fm\u0016d7O\u0003\u0002\u000b\u0017\u00051Q.\u001a;bYNT!\u0001D\u0007\u0002\u0011%tG/\u001a:oC2T!AD\b\u0002\t5,G/\u0019\u0006\u0002!\u0005)1oY1mC\u000e\u00011C\u0001\u0001\u0014!\t!R#D\u0001\u0010\u0013\t1rB\u0001\u0004B]f\u0014VMZ\u0001\u0005G>tg\u000eE\u0002\u00153mI!AG\b\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004C\u0001\u000f\"\u001b\u0005i\"B\u0001\u0010 \u0003\r\u0019\u0018\u000f\u001c\u0006\u0002A\u0005!!.\u0019<b\u0013\t\u0011SD\u0001\u0006D_:tWm\u0019;j_:\fa\u0001P5oSRtDCA\u0013(!\t1\u0003!D\u0001\n\u0011\u00159\"\u00011\u0001\u0019\u000319W\r\u001e+pa2+g/\u001a7t)\tQ#\nE\u0002\u0015W5J!\u0001L\b\u0003\r=\u0003H/[8o!\rqc'\u000f\b\u0003_Qr!\u0001M\u001a\u000e\u0003ER!AM\t\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0001\u0012BA\u001b\u0010\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u000e\u001d\u0003\t1K7\u000f\u001e\u0006\u0003k=\u0001B\u0001\u0006\u001e=\t&\u00111h\u0004\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005u\neB\u0001 @!\t\u0001t\"\u0003\u0002A\u001f\u00051\u0001K]3eK\u001aL!AQ\"\u0003\rM#(/\u001b8h\u0015\t\u0001u\u0002\u0005\u0002F\u00116\taI\u0003\u0002H\u001b\u0005\u0011\u0011n\\\u0005\u0003\u0013\u001a\u0013A\"\u00112t_2,H/\u001a)bi\"DQaS\u0002A\u0002\u0011\u000bA\u0001]1uQ\u0006a\u0001/\u001e;U_BdUM^3mgR\u0019a*\u0015*\u0011\u0005Qy\u0015B\u0001)\u0010\u0005\rIe\u000e\u001e\u0005\u0006\u0017\u0012\u0001\r\u0001\u0012\u0005\u0006'\u0012\u0001\r!L\u0001\ni>\u0004H.\u001a<fYN\fa\u0003Z3mKR,gj\u001c;Vg\u0016$Gk\u001c9MKZ,Gn\u001d\u000b\u0003\u001dZCQaV\u0003A\u0002a\u000b\u0011\"^:fIB\u000bG\u000f[:\u0011\u0007QIF)\u0003\u0002[\u001f\t)\u0011I\u001d:bs\u0006aq-\u001a;N\tV\"\u0015nZ3tiR\u0011A(\u0018\u0005\u0006\u0017\u001a\u0001\r\u0001R\u0001\tG2,\u0017M]!mYR\t\u0001\r\u0005\u0002\u0015C&\u0011!m\u0004\u0002\u0005+:LG\u000f")
public final class JarTopLevels {
    private final Function0<Connection> conn;

    public Option<List<Tuple2<String, AbsolutePath>>> getTopLevels(AbsolutePath path2) {
        None$ none$;
        try {
            FileSystem fs = (FileSystem)MetalsEnrichments$.MODULE$.XtensionAbsolutePath(path2).jarPath().map((Function1 & Serializable)jarPath -> PlatformFileIO$.MODULE$.newFileSystem(jarPath.toURI(), new HashMap())).getOrElse((Function0 & Serializable)() -> PlatformFileIO$.MODULE$.newJarFileSystem(path2, false));
            Builder toplevels = package$.MODULE$.List().newBuilder();
            none$ = JdbcEnrichments$.MODULE$.XtensionConnection((Connection)this.conn.apply()).query(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("select ts.symbol, ts.path\n            |from indexed_jar ij\n            |left join toplevel_symbol ts\n            |on ij.id=ts.jar\n            |where ij.md5=?")), (Function1<PreparedStatement, BoxedUnit>)(Function1 & Serializable)x$1 -> {
                x$1.setString(1, this.getMD5Digest(path2));
                return BoxedUnit.UNIT;
            }, (Function1 & Serializable)rs -> {
                if (rs.getString(1) != null && rs.getString(2) != null) {
                    String symbol = rs.getString(1);
                    AbsolutePath path2 = AbsolutePath$.MODULE$.apply(fs.getPath(rs.getString(2), new String[0]), AbsolutePath$.MODULE$.workingDirectory());
                    return toplevels.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)symbol), (Object)path2));
                }
                return BoxedUnit.UNIT;
            }).headOption().map((Function1 & Serializable)x$2 -> (List)toplevels.result());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ZipError ? true : throwable2 instanceof ZipException) {
                none$ = None$.MODULE$;
            }
            throw throwable;
        }
        return none$;
    }

    public int putTopLevels(AbsolutePath path2, List<Tuple2<String, AbsolutePath>> toplevels) {
        int n;
        int n2;
        if (toplevels.isEmpty()) {
            return 0;
        }
        try (Statement jarStmt = null;){
            jarStmt = ((Connection)this.conn.apply()).prepareStatement("insert into indexed_jar (md5) values (?)", 1);
            jarStmt.setString(1, this.getMD5Digest(path2));
            jarStmt.executeUpdate();
            ResultSet rs = jarStmt.getGeneratedKeys();
            rs.next();
            n2 = rs.getInt("id");
        }
        int jar = n2;
        ObjectRef symbolStmt = ObjectRef.create(null);
        try {
            symbolStmt.elem = ((Connection)this.conn.apply()).prepareStatement("insert into toplevel_symbol (symbol, path, jar) values (?, ?, ?)");
            toplevels.foreach((Function1 & Serializable)x0$1 -> {
                JarTopLevels.$anonfun$putTopLevels$1(symbolStmt, jar, x0$1);
                return BoxedUnit.UNIT;
            });
            n = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.wrapIntArray(((PreparedStatement)symbolStmt.elem).executeBatch()).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        }
        finally {
            if ((PreparedStatement)symbolStmt.elem != null) {
                ((PreparedStatement)symbolStmt.elem).close();
            }
        }
        return n;
    }

    public int deleteNotUsedTopLevels(AbsolutePath[] usedPaths) {
        String md5s = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])usedPaths), (Function1 & Serializable)path2 -> this.getMD5Digest((AbsolutePath)path2), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)x$3 -> new StringBuilder(2).append("'").append((String)x$3).append("'").toString(), ClassTag$.MODULE$.apply(String.class))).mkString(",");
        return JdbcEnrichments$.MODULE$.XtensionConnection((Connection)this.conn.apply()).update(new StringBuilder(43).append("delete from indexed_jar where md5 not in (").append(md5s).append(")").toString(), (Function1<PreparedStatement, BoxedUnit>)(Function1 & Serializable)x$4 -> {
            JarTopLevels.$anonfun$deleteNotUsedTopLevels$3(x$4);
            return BoxedUnit.UNIT;
        });
    }

    private String getMD5Digest(AbsolutePath path2) {
        BasicFileAttributes attributes = Files.getFileAttributeView(path2.toNIO(), BasicFileAttributeView.class, new LinkOption[0]).readAttributes();
        return MD5$.MODULE$.compute(new StringBuilder(2).append(path2.toString()).append(":").append(attributes.lastModifiedTime().toMillis()).append(":").append(attributes.size()).toString());
    }

    public void clearAll() {
        PreparedStatement statement1 = ((Connection)this.conn.apply()).prepareStatement("truncate table toplevel_symbol");
        statement1.execute();
        PreparedStatement statement2 = ((Connection)this.conn.apply()).prepareStatement("delete from indexed_jar");
        statement2.execute();
    }

    public static final /* synthetic */ void $anonfun$putTopLevels$1(ObjectRef symbolStmt$1, int jar$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String symbol = (String)tuple2._1();
            AbsolutePath source = (AbsolutePath)tuple2._2();
            ((PreparedStatement)symbolStmt$1.elem).setString(1, symbol);
            ((PreparedStatement)symbolStmt$1.elem).setString(2, source.toString());
            ((PreparedStatement)symbolStmt$1.elem).setInt(3, jar$1);
            ((PreparedStatement)symbolStmt$1.elem).addBatch();
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$deleteNotUsedTopLevels$3(PreparedStatement x$4) {
    }

    public JarTopLevels(Function0<Connection> conn) {
        this.conn = conn;
    }
}

