/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.Serializable;
import java.nio.file.FileSystemException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.meta.internal.metals.BuildTargets;
import scala.meta.internal.metals.Directories$;
import scala.meta.internal.metals.MetalsEnrichments$;
import scala.meta.internal.metals.SemanticdbFeatureProvider;
import scala.meta.internal.mtags.SemanticdbClasspath$;
import scala.meta.internal.mtags.SemanticdbPath;
import scala.meta.internal.mtags.SemanticdbPath$;
import scala.meta.internal.semanticdb.TextDocument;
import scala.meta.internal.semanticdb.TextDocuments;
import scala.meta.internal.semanticdb.TextDocuments$;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;
import scribe.data.MDC$;
import scribe.message.LoggableMessage;
import scribe.message.LoggableMessage$;
import scribe.package$;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;

@ScalaSignature(bytes="\u0006\u0005Q4A!\u0004\b\u0001/!AA\u0004\u0001B\u0001B\u0003%Q\u0004\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003/\u0011!\t\u0004A!A!\u0002\u0013\u0011\u0004\"\u0002\u001d\u0001\t\u0003I\u0004\"\u0002 \u0001\t\u0003y\u0004\"B\"\u0001\t\u0003y\u0004\"\u0002#\u0001\t\u0003)\u0005\"\u0002(\u0001\t\u0003y\u0005\"\u0002*\u0001\t\u0013\u0019\u0006\"\u00021\u0001\t\u0003\t\u0007\"\u00021\u0001\t\u0013Y\u0007\"\u00021\u0001\t\u0003\u0011(!E*f[\u0006tG/[2eE&sG-\u001a=fe*\u0011q\u0002E\u0001\u0007[\u0016$\u0018\r\\:\u000b\u0005E\u0011\u0012\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005M!\u0012\u0001B7fi\u0006T\u0011!F\u0001\u0006g\u000e\fG.Y\u0002\u0001'\t\u0001\u0001\u0004\u0005\u0002\u001a55\tA#\u0003\u0002\u001c)\t1\u0011I\\=SK\u001a\f\u0011\u0002\u001d:pm&$WM]:\u0011\u0007y1\u0013F\u0004\u0002 I9\u0011\u0001eI\u0007\u0002C)\u0011!EF\u0001\u0007yI|w\u000e\u001e \n\u0003UI!!\n\u000b\u0002\u000fA\f7m[1hK&\u0011q\u0005\u000b\u0002\u0005\u0019&\u001cHO\u0003\u0002&)A\u0011!fK\u0007\u0002\u001d%\u0011AF\u0004\u0002\u001a'\u0016l\u0017M\u001c;jG\u0012\u0014g)Z1ukJ,\u0007K]8wS\u0012,'/\u0001\u0007ck&dG\rV1sO\u0016$8\u000f\u0005\u0002+_%\u0011\u0001G\u0004\u0002\r\u0005VLG\u000e\u001a+be\u001e,Go]\u0001\no>\u00148n\u001d9bG\u0016\u0004\"a\r\u001c\u000e\u0003QR!!\u000e\n\u0002\u0005%|\u0017BA\u001c5\u00051\t%m]8mkR,\u0007+\u0019;i\u0003\u0019a\u0014N\\5u}Q!!h\u000f\u001f>!\tQ\u0003\u0001C\u0003\u001d\t\u0001\u0007Q\u0004C\u0003.\t\u0001\u0007a\u0006C\u00032\t\u0001\u0007!'A\u0007p]R\u000b'oZ3u%>|Go\u001d\u000b\u0002\u0001B\u0011\u0011$Q\u0005\u0003\u0005R\u0011A!\u00168ji\u0006)!/Z:fi\u0006AqN\u001c#fY\u0016$X\r\u0006\u0002A\r\")qi\u0002a\u0001\u0011\u0006q1/Z7b]RL7\r\u001a2GS2,\u0007CA%M\u001b\u0005Q%BA&\u0011\u0003\u0015iG/Y4t\u0013\ti%J\u0001\bTK6\fg\u000e^5dI\n\u0004\u0016\r\u001e5\u0002\u0015=twJ^3sM2|w\u000f\u0006\u0002A!\")\u0011\u000b\u0003a\u0001\u0011\u0006!\u0001/\u0019;i\u0003Eygn\u00115b]\u001e,G)\u001b:fGR|'/\u001f\u000b\u0003\u0001RCQ!V\u0005A\u0002Y\u000b1\u0001Z5s!\t9f,D\u0001Y\u0015\tI&,\u0001\u0003gS2,'BA.]\u0003\rq\u0017n\u001c\u0006\u0002;\u0006!!.\u0019<b\u0013\ty\u0006L\u0001\u0003QCRD\u0017\u0001C8o\u0007\"\fgnZ3\u0015\u0007\u0001\u00137\rC\u0003R\u0015\u0001\u0007!\u0007C\u0003e\u0015\u0001\u0007Q-\u0001\u0007uKb$Hi\\2v[\u0016tG\u000f\u0005\u0002gS6\tqM\u0003\u0002i!\u0005Q1/Z7b]RL7\r\u001a2\n\u0005)<'\u0001\u0004+fqR$unY;nK:$Hc\u0001!m[\")\u0011k\u0003a\u0001e!)an\u0003a\u0001_\u0006!Am\\2t!\t1\u0007/\u0003\u0002rO\niA+\u001a=u\t>\u001cW/\\3oiN$\"\u0001Q:\t\u000bec\u0001\u0019\u0001%")
public class SemanticdbIndexer {
    private final List<SemanticdbFeatureProvider> providers;
    private final BuildTargets buildTargets;
    private final AbsolutePath workspace;

    public void onTargetRoots() {
        this.buildTargets.allTargetRoots().foreach((Function1 & Serializable)targetRoot -> {
            this.onChangeDirectory(targetRoot.resolve(Directories$.MODULE$.semanticdb()).toNIO());
            return BoxedUnit.UNIT;
        });
    }

    public void reset() {
        this.providers.foreach((Function1 & Serializable)x$1 -> {
            x$1.reset();
            return BoxedUnit.UNIT;
        });
    }

    public void onDelete(AbsolutePath semanticdbFile) {
        this.providers.foreach((Function1 & Serializable)x$2 -> {
            x$2.onDelete(semanticdbFile);
            return BoxedUnit.UNIT;
        });
    }

    public void onOverflow(AbsolutePath path2) {
        if (new SemanticdbPath(path2) == null) {
            this.onTargetRoots();
            return;
        }
        SemanticdbPath$.MODULE$.semanticdbRoot$extension(path2).foreach((Function1 & Serializable)x$3 -> {
            this.onChangeDirectory(x$3);
            return BoxedUnit.UNIT;
        });
    }

    private void onChangeDirectory(Path dir) {
        if (Files.isDirectory(dir, new LinkOption[0])) {
            try (Stream<Path> stream = Files.walk(dir, new FileVisitOption[0]);){
                stream.forEach(x0$1 -> {
                    Path path2 = x0$1;
                    if (MetalsEnrichments$.MODULE$.XtensionPath(path2).isSemanticdb()) {
                        this.onChange(AbsolutePath$.MODULE$.apply(path2, AbsolutePath$.MODULE$.workingDirectory()));
                        return;
                    }
                });
            }
            return;
        }
    }

    public void onChange(AbsolutePath path2, TextDocument textDocument) {
        TextDocuments docs = new TextDocuments((Seq)new .colon.colon((Object)textDocument, (List)Nil$.MODULE$));
        this.onChange(path2, docs);
    }

    private void onChange(AbsolutePath path2, TextDocuments docs) {
        this.providers.foreach((Function1 & Serializable)x$4 -> {
            x$4.onChange(docs, path2);
            return BoxedUnit.UNIT;
        });
    }

    public void onChange(AbsolutePath file) {
        if (!Files.isDirectory(SemanticdbPath$.MODULE$.toNIO$extension(file), new LinkOption[0])) {
            try {
                TextDocuments docs = (TextDocuments)TextDocuments$.MODULE$.parseFrom(Files.readAllBytes(SemanticdbPath$.MODULE$.toNIO$extension(file)));
                SemanticdbClasspath$.MODULE$.toScala(this.workspace, file).foreach((Function1 & Serializable)sourceFile -> {
                    this.onChange(sourceFile, docs);
                    return BoxedUnit.UNIT;
                });
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 instanceof InvalidProtocolBufferException) {
                    InvalidProtocolBufferException invalidProtocolBufferException = (InvalidProtocolBufferException)throwable2;
                    BoxedUnit cfr_ignored_0 = (BoxedUnit)package$.MODULE$.debug((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LoggableMessage[]{LoggableMessage$.MODULE$.string2Message((Function0 & Serializable)() -> new StringBuilder(17).append(new SemanticdbPath(file)).append(" is not yet ready").toString()), LoggableMessage$.MODULE$.throwable2Message((Function0 & Serializable)() -> invalidProtocolBufferException)}), new Pkg("scala.meta.internal.metals"), new FileName("SemanticdbIndexer.scala"), new Name("onChange"), new Line(100), MDC$.MODULE$.global());
                }
                if (throwable2 instanceof FileSystemException) {
                    FileSystemException fileSystemException = (FileSystemException)throwable2;
                    BoxedUnit cfr_ignored_1 = (BoxedUnit)package$.MODULE$.debug((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LoggableMessage[]{LoggableMessage$.MODULE$.string2Message((Function0 & Serializable)() -> new StringBuilder(17).append(new SemanticdbPath(file)).append(" is not yet ready").toString()), LoggableMessage$.MODULE$.throwable2Message((Function0 & Serializable)() -> fileSystemException)}), new Pkg("scala.meta.internal.metals"), new FileName("SemanticdbIndexer.scala"), new Name("onChange"), new Line(103), MDC$.MODULE$.global());
                }
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    BoxedUnit cfr_ignored_2 = (BoxedUnit)package$.MODULE$.warn((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LoggableMessage[]{LoggableMessage$.MODULE$.string2Message((Function0 & Serializable)() -> new StringBuilder(37).append("unexpected error processing the file ").append(new SemanticdbPath(file)).toString()), LoggableMessage$.MODULE$.throwable2Message((Function0 & Serializable)() -> e)}), new Pkg("scala.meta.internal.metals"), new FileName("SemanticdbIndexer.scala"), new Name("onChange"), new Line(105), MDC$.MODULE$.global());
                }
                throw throwable;
            }
            return;
        }
    }

    public SemanticdbIndexer(List<SemanticdbFeatureProvider> providers, BuildTargets buildTargets, AbsolutePath workspace) {
        this.providers = providers;
        this.buildTargets = buildTargets;
        this.workspace = workspace;
    }
}

