/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.htmlunit.logging;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.htmlunit.WebClient;
import org.htmlunit.WebConsole;
import org.openqa.selenium.logging.LogEntries;
import org.openqa.selenium.logging.LogEntry;
import org.openqa.selenium.logging.Logs;

public class HtmlUnitLogs
implements Logs {
    private final HtmlUnitDriverLogger logger_ = new HtmlUnitDriverLogger();

    public HtmlUnitLogs(WebClient webClient) {
        webClient.getWebConsole().setLogger((WebConsole.Logger)this.logger_);
    }

    public LogEntries get(String logType) {
        if ("browser".equals(logType)) {
            return new LogEntries(this.logger_.getContentAndFlush());
        }
        return new LogEntries(Collections.emptyList());
    }

    public Set<String> getAvailableLogTypes() {
        return Collections.emptySet();
    }

    private static final class HtmlUnitDriverLogger
    implements WebConsole.Logger {
        private static final int BUFFER_SIZE = 1000;
        private final LogEntry[] buffer_ = new LogEntry[1000];
        private int insertPos_ = 0;
        private boolean isFull_ = false;

        private HtmlUnitDriverLogger() {
        }

        private void append(LogEntry entry) {
            this.buffer_[this.insertPos_] = entry;
            ++this.insertPos_;
            if (this.insertPos_ == 1000) {
                this.insertPos_ = 0;
                this.isFull_ = true;
            }
        }

        private List<LogEntry> getContentAndFlush() {
            int i;
            ArrayList<LogEntry> result;
            if (this.isFull_) {
                result = new ArrayList<LogEntry>(1000);
                for (i = this.insertPos_; i < 1000; ++i) {
                    result.add(this.buffer_[i]);
                }
            } else {
                result = new ArrayList(this.insertPos_);
            }
            for (i = 0; i < this.insertPos_; ++i) {
                result.add(this.buffer_[i]);
            }
            this.insertPos_ = 0;
            this.isFull_ = false;
            return result;
        }

        public void warn(Object message) {
            this.append(new LogEntry(Level.WARNING, System.currentTimeMillis(), message == null ? "" : message.toString()));
        }

        public void trace(Object message) {
            this.append(new LogEntry(Level.FINEST, System.currentTimeMillis(), message == null ? "" : message.toString()));
        }

        public void info(Object message) {
            this.append(new LogEntry(Level.INFO, System.currentTimeMillis(), message == null ? "" : message.toString()));
        }

        public void error(Object message) {
            this.append(new LogEntry(Level.SEVERE, System.currentTimeMillis(), message == null ? "" : message.toString()));
        }

        public void debug(Object message) {
            this.append(new LogEntry(Level.FINE, System.currentTimeMillis(), message == null ? "" : message.toString()));
        }

        public boolean isTraceEnabled() {
            return false;
        }

        public boolean isDebugEnabled() {
            return false;
        }

        public boolean isInfoEnabled() {
            return true;
        }

        public boolean isWarnEnabled() {
            return true;
        }

        public boolean isErrorEnabled() {
            return true;
        }
    }
}

