/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v142.emulation.model;

import java.util.Arrays;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

@Beta
public enum PressureSource {
    CPU("cpu");

    private String value;

    private PressureSource(String value) {
        this.value = value;
    }

    public static PressureSource fromString(String s) {
        return Arrays.stream(PressureSource.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within PressureSource "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static PressureSource fromJson(JsonInput input) {
        return PressureSource.fromString(input.nextString());
    }
}

