/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.asm;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.simpleflatmapper.ow2asm.ClassWriter;
import org.simpleflatmapper.ow2asm.FieldVisitor;
import org.simpleflatmapper.ow2asm.MethodVisitor;
import org.simpleflatmapper.reflect.BiInstantiator;
import org.simpleflatmapper.reflect.BuilderInstantiatorDefinition;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.Instantiator;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.Parameter;
import org.simpleflatmapper.reflect.asm.AsmUtils;
import org.simpleflatmapper.reflect.getter.BiFunctionGetter;
import org.simpleflatmapper.reflect.instantiator.ExecutableInstantiatorDefinition;
import org.simpleflatmapper.reflect.primitive.BooleanGetter;
import org.simpleflatmapper.reflect.primitive.ByteGetter;
import org.simpleflatmapper.reflect.primitive.CharacterGetter;
import org.simpleflatmapper.reflect.primitive.DoubleGetter;
import org.simpleflatmapper.reflect.primitive.FloatGetter;
import org.simpleflatmapper.reflect.primitive.IntGetter;
import org.simpleflatmapper.reflect.primitive.LongGetter;
import org.simpleflatmapper.reflect.primitive.ShortGetter;
import org.simpleflatmapper.util.BiFunction;
import org.simpleflatmapper.util.TypeHelper;

public class BiInstantiatorBuilder {
    public static final Class<BiInstantiator> BI_INSTANTIATOR_CLASS = BiInstantiator.class;
    public static final Class<Instantiator> INSTANTIATOR_CLASS = Instantiator.class;
    public static final String BI_FUNCTION_PREFIX = "factory_";
    static final Map<Class<?>, Class<?>> primitivesGetter = new HashMap();

    public static <S1, S2> byte[] createInstantiator(String className, Class<?> s1, Class<?> s2, ExecutableInstantiatorDefinition instantiatorDefinition, Map<Parameter, BiFunction<? super S1, ? super S2, ?>> injectionsMap) throws Exception {
        ClassWriter cw = new ClassWriter(1);
        Class targetClass = TypeHelper.toClass((Type)BiInstantiatorBuilder.getTargetType(instantiatorDefinition));
        String targetType = AsmUtils.toAsmType(targetClass);
        String s1Type = AsmUtils.toWrapperType(s1);
        String s2Type = AsmUtils.toWrapperType(s2);
        String classType = AsmUtils.toAsmType(className);
        String instantiatorType = AsmUtils.toAsmType(BI_INSTANTIATOR_CLASS);
        List<InjectionPoint> injections = BiInstantiatorBuilder.toInjections(injectionsMap);
        cw.visit(50, 49, classType, "Ljava/lang/Object;L" + instantiatorType + "<L" + targetType + ";>;", "java/lang/Object", new String[]{instantiatorType});
        Parameter[] parameters = instantiatorDefinition.getParameters();
        BiInstantiatorBuilder.appendFunctionsField(injections, cw);
        BiInstantiatorBuilder.appendInit(injections, cw, s1Type, s2Type, classType);
        BiInstantiatorBuilder.appendNewInstance(s1, s2, instantiatorDefinition, injections, cw, targetType, s1Type, s2Type, classType, parameters);
        BiInstantiatorBuilder.appendBridgeMethod(cw, targetType, s1Type, s2Type, classType);
        BiInstantiatorBuilder.appendToString(injections, cw, parameters);
        cw.visitEnd();
        return AsmUtils.writeClassToFile(className, cw.toByteArray());
    }

    private static <S1, S2> List<InjectionPoint> toInjections(Map<Parameter, BiFunction<? super S1, ? super S2, ?>> injectionsMap) {
        ArrayList<InjectionPoint> injections = new ArrayList<InjectionPoint>(injectionsMap.size());
        for (Map.Entry<Parameter, BiFunction<S1, S2, ?>> e : injectionsMap.entrySet()) {
            injections.add(BiInstantiatorBuilder.getFunctionCall(e.getKey(), e.getValue()));
        }
        return injections;
    }

    public static <S1, S2> byte[] createInstantiator(String className, Class<?> s1, Class<?> s2, Instantiator<Void, ?> builderInstantiator, BuilderInstantiatorDefinition instantiatorDefinition, Map<Parameter, BiFunction<? super S1, ? super S2, ?>> injectionsMap) throws Exception {
        ClassWriter cw = new ClassWriter(1);
        Class targetClass = TypeHelper.toClass((Type)BiInstantiatorBuilder.getTargetType(instantiatorDefinition));
        String targetType = AsmUtils.toAsmType(targetClass);
        String s1Type = AsmUtils.toWrapperType(s1);
        String s2Type = AsmUtils.toWrapperType(s2);
        String classType = AsmUtils.toAsmType(className);
        String instantiatorType = AsmUtils.toAsmType(BI_INSTANTIATOR_CLASS);
        List<InjectionPoint> injections = BiInstantiatorBuilder.toInjections(injectionsMap);
        cw.visit(50, 49, classType, "Ljava/lang/Object;L" + instantiatorType + "<L" + targetType + ";>;", "java/lang/Object", new String[]{instantiatorType});
        FieldVisitor fv = cw.visitField(16, "builderInstantiator", "L" + AsmUtils.toAsmType(INSTANTIATOR_CLASS) + ";", "L" + AsmUtils.toAsmType(INSTANTIATOR_CLASS) + "<Ljava/lang/Void;L" + AsmUtils.toAsmType(BiInstantiatorBuilder.getTargetType(instantiatorDefinition.getBuilderInstantiator())) + ";>;", null);
        fv.visitEnd();
        BiInstantiatorBuilder.appendFunctionsField(injections, cw);
        BiInstantiatorBuilder.appendInitBuilder(injections, cw, s1Type, s2Type, classType, instantiatorDefinition);
        BiInstantiatorBuilder.appendNewInstanceBuilder(s1, s2, instantiatorDefinition, injections, cw, targetType, s1Type, s2Type, classType, instantiatorDefinition.getSetters());
        BiInstantiatorBuilder.appendBridgeMethod(cw, targetType, s1Type, s2Type, classType);
        BiInstantiatorBuilder.appendToString(injections, cw, instantiatorDefinition.getParameters());
        cw.visitEnd();
        return AsmUtils.writeClassToFile(className, cw.toByteArray());
    }

    private static <S1, S2> void appendFunctionsField(List<InjectionPoint> injections, ClassWriter cw) {
        for (InjectionPoint injectionPoint : injections) {
            FieldVisitor fv = cw.visitField(16, BiInstantiatorBuilder.getBiFunctionFieldName(injectionPoint.parameter), AsmUtils.toTargetTypeDeclaration(injectionPoint.functionType), null, null);
            fv.visitEnd();
        }
    }

    private static <S1, S2> void appendInit(List<InjectionPoint> injections, ClassWriter cw, String s1, String s2, String classType) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", "(Ljava/util/Map;)V", "(Ljava/util/Map<Ljava.lang.String;L" + AsmUtils.toAsmType(BiFunction.class) + "<" + AsmUtils.toTargetTypeDeclaration(s1) + "*" + AsmUtils.toTargetTypeDeclaration(s2) + "*>;>;)V", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        BiInstantiatorBuilder.appendInitField(injections, classType, mv);
        mv.visitInsn(177);
        mv.visitMaxs(3, 2);
        mv.visitEnd();
    }

    private static <S1, S2> void appendInitBuilder(List<InjectionPoint> injections, ClassWriter cw, String s1, String s2, String classType, BuilderInstantiatorDefinition instantiatorDefinition) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", "(Ljava/util/Map;L" + AsmUtils.toAsmType(INSTANTIATOR_CLASS) + ";)V", "(Ljava/util/Map<Ljava.lang.String;L" + AsmUtils.toAsmType(BiFunction.class) + "<" + AsmUtils.toTargetTypeDeclaration(s1) + "*" + AsmUtils.toTargetTypeDeclaration(s2) + "*>;>;L" + AsmUtils.toAsmType(INSTANTIATOR_CLASS) + "<Ljava/lang/Void;L" + AsmUtils.toAsmType(BiInstantiatorBuilder.getTargetType(instantiatorDefinition.getBuilderInstantiator())) + ";>;)V", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 2);
        mv.visitFieldInsn(181, classType, "builderInstantiator", "L" + AsmUtils.toAsmType(INSTANTIATOR_CLASS) + ";");
        BiInstantiatorBuilder.appendInitField(injections, classType, mv);
        mv.visitInsn(177);
        mv.visitMaxs(3, 2);
        mv.visitEnd();
    }

    private static <S1, S2> void appendInitField(List<InjectionPoint> injections, String classType, MethodVisitor mv) {
        for (InjectionPoint injectionPoint : injections) {
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitLdcInsn(injectionPoint.parameter.getName());
            mv.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
            if (injectionPoint.isGetter) {
                mv.visitTypeInsn(192, AsmUtils.toAsmType(BiFunctionGetter.class));
                mv.visitMethodInsn(182, AsmUtils.toAsmType(BiFunctionGetter.class), "getGetter", "()" + AsmUtils.toTargetTypeDeclaration(Getter.class), false);
            }
            mv.visitTypeInsn(192, AsmUtils.toAsmType(injectionPoint.functionType));
            mv.visitFieldInsn(181, classType, BiInstantiatorBuilder.getBiFunctionFieldName(injectionPoint.parameter), AsmUtils.toTargetTypeDeclaration(injectionPoint.functionType));
        }
    }

    private static <S1, S2> void appendNewInstance(Class<?> s1, Class<?> s2, ExecutableInstantiatorDefinition instantiatorDefinition, List<InjectionPoint> injectionPoints, ClassWriter cw, String targetType, String s1Type, String s2Type, String classType, Parameter[] parameters) throws NoSuchMethodException {
        MethodVisitor mv = cw.visitMethod(1, "newInstance", "(" + AsmUtils.toTargetTypeDeclaration(s1Type) + AsmUtils.toTargetTypeDeclaration(s2Type) + ")" + AsmUtils.toTargetTypeDeclaration(targetType), null, new String[]{"java/lang/Exception"});
        mv.visitCode();
        mv.visitTypeInsn(187, targetType);
        mv.visitInsn(89);
        StringBuilder sb = new StringBuilder();
        for (Parameter p : parameters) {
            InjectionPoint function = BiInstantiatorBuilder.findFunctionCalls(p, injectionPoints);
            sb.append(AsmUtils.toTargetTypeDeclaration(p.getType()));
            if (function == null) {
                BiInstantiatorBuilder.newInstanceNullFunction(mv, p);
                continue;
            }
            BiInstantiatorBuilder.invokeBiFunction(function, classType, s1, s2, mv);
        }
        Member exec = instantiatorDefinition.getExecutable();
        if (exec instanceof Constructor) {
            mv.visitMethodInsn(183, targetType, "<init>", "(" + sb.toString() + ")V", false);
        } else {
            mv.visitMethodInsn(184, AsmUtils.toAsmType(((Method)exec).getDeclaringClass()), exec.getName(), AsmUtils.toSignature((Method)exec), false);
        }
        mv.visitInsn(176);
        mv.visitMaxs(3, 2);
        mv.visitEnd();
    }

    private static <S1, S2> void appendNewInstanceBuilder(Class<?> s1, Class<?> s2, BuilderInstantiatorDefinition instantiatorDefinition, List<InjectionPoint> injectionPoints, ClassWriter cw, String targetType, String s1Type, String s2Type, String classType, Map<Parameter, Method> setters) throws NoSuchMethodException {
        MethodVisitor mv = cw.visitMethod(1, "newInstance", "(" + AsmUtils.toTargetTypeDeclaration(s1Type) + AsmUtils.toTargetTypeDeclaration(s2Type) + ")" + AsmUtils.toTargetTypeDeclaration(targetType), null, new String[]{"java/lang/Exception"});
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, classType, "builderInstantiator", AsmUtils.toTargetTypeDeclaration(INSTANTIATOR_CLASS));
        mv.visitInsn(1);
        mv.visitMethodInsn(185, AsmUtils.toAsmType(INSTANTIATOR_CLASS), "newInstance", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
        Type builderClass = BiInstantiatorBuilder.getTargetType(instantiatorDefinition.getBuilderInstantiator());
        String builderType = AsmUtils.toAsmType(builderClass);
        mv.visitTypeInsn(192, builderType);
        mv.visitVarInsn(58, 2);
        for (Map.Entry<Parameter, Method> e : setters.entrySet()) {
            mv.visitVarInsn(25, 2);
            Parameter p = e.getKey();
            InjectionPoint injectionPoint = BiInstantiatorBuilder.findFunctionCalls(p, injectionPoints);
            if (injectionPoint == null) {
                BiInstantiatorBuilder.newInstanceNullFunction(mv, p);
                continue;
            }
            BiInstantiatorBuilder.invokeBiFunction(injectionPoint, classType, s1, s2, mv);
            AsmUtils.invoke(mv, TypeHelper.toClass((Type)builderClass), e.getValue().getName(), AsmUtils.toSignature(e.getValue()));
            if (Void.TYPE.equals(e.getValue().getReturnType())) continue;
            mv.visitVarInsn(58, 2);
        }
        mv.visitVarInsn(25, 2);
        AsmUtils.invoke(mv, TypeHelper.toClass((Type)builderClass), instantiatorDefinition.getBuildMethod().getName(), AsmUtils.toSignature(instantiatorDefinition.getBuildMethod()));
        mv.visitInsn(176);
        mv.visitMaxs(3, 2);
        mv.visitEnd();
    }

    private static InjectionPoint findFunctionCalls(Parameter p, List<InjectionPoint> injectionPoints) {
        for (InjectionPoint fc : injectionPoints) {
            if (!fc.parameter.equals(p)) continue;
            return fc;
        }
        return null;
    }

    private static void newInstanceNullFunction(MethodVisitor mv, Parameter p) {
        if (TypeHelper.isPrimitive(p.getType())) {
            mv.visitInsn(AsmUtils.defaultValue.get(p.getType()));
        } else {
            mv.visitInsn(1);
        }
    }

    private static <S1, S2> void invokeBiFunction(InjectionPoint injectionPoint, String classType, Class<?> s1, Class<?> s2, MethodVisitor mv) throws NoSuchMethodException {
        String s1Type = AsmUtils.toAsmType(s1.equals(Void.class) || s1.equals(Void.TYPE) ? Object.class : s1);
        String s2Type = AsmUtils.toAsmType(s2.equals(Void.class) || s2.equals(Void.TYPE) ? Object.class : s2);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, classType, BiInstantiatorBuilder.getBiFunctionFieldName(injectionPoint.parameter), AsmUtils.toTargetTypeDeclaration(injectionPoint.functionType));
        mv.visitVarInsn(25, 1);
        if (!injectionPoint.isGetter) {
            mv.visitVarInsn(25, 2);
        }
        Method getterMethod = injectionPoint.getMethod();
        AsmUtils.invoke(mv, injectionPoint.functionType, getterMethod);
        if (!injectionPoint.isPrimitive) {
            Class<?> wrapperClass = AsmUtils.toWrapperClass(injectionPoint.parameter.getType());
            if (!wrapperClass.isAssignableFrom(getterMethod.getReturnType())) {
                mv.visitTypeInsn(192, AsmUtils.toAsmType(wrapperClass));
            }
            if (TypeHelper.isPrimitive(injectionPoint.parameter.getType())) {
                String methodSuffix = BiInstantiatorBuilder.getPrimitiveMethodSuffix(injectionPoint.parameter);
                String valueMethodPrefix = methodSuffix.toLowerCase();
                if ("character".equals(valueMethodPrefix)) {
                    valueMethodPrefix = "char";
                }
                String valueMethod = valueMethodPrefix + "Value";
                AsmUtils.invoke(mv, wrapperClass, valueMethod, "()" + AsmUtils.toAsmType(injectionPoint.parameter.getType()));
            }
        }
    }

    private static String getBiFunctionFieldName(Parameter p) {
        return BI_FUNCTION_PREFIX + p.getName();
    }

    private static String getPrimitiveMethodSuffix(Parameter p) {
        return BiInstantiatorBuilder.getPrimitiveMethodSuffix(p.getType());
    }

    private static String getPrimitiveMethodSuffix(Class<?> type) {
        String methodSuffix = AsmUtils.wrappers.get(type).getSimpleName();
        if ("Integer".equals(methodSuffix)) {
            methodSuffix = "Int";
        }
        return methodSuffix;
    }

    private static void appendBridgeMethod(ClassWriter cw, String targetType, String s1Type, String s2Type, String classType) {
        MethodVisitor mv = cw.visitMethod(4161, "newInstance", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", null, new String[]{"java/lang/Exception"});
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, s1Type);
        mv.visitVarInsn(25, 2);
        mv.visitTypeInsn(192, s2Type);
        mv.visitMethodInsn(182, classType, "newInstance", "(" + AsmUtils.toTargetTypeDeclaration(s1Type) + AsmUtils.toTargetTypeDeclaration(s2Type) + ")" + AsmUtils.toTargetTypeDeclaration(targetType), false);
        mv.visitInsn(176);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
    }

    private static <S1, S2> void appendToString(List<InjectionPoint> injections, ClassWriter cw, Parameter[] parameters) {
        MethodVisitor mv = cw.visitMethod(1, "toString", "()Ljava/lang/String;", null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, "java/lang/StringBuilder");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "()V", false);
        mv.visitVarInsn(58, 1);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, "java/lang/Object", "getClass", "()Ljava/lang/Class;", false);
        mv.visitMethodInsn(182, "java/lang/Class", "getSimpleName", "()Ljava/lang/String;", false);
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        mv.visitLdcInsn("{");
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        for (int i = 0; i < parameters.length; ++i) {
            String paramName = (i > 0 ? ", " : "") + "parameter" + i + "=";
            String parameter = String.valueOf(parameters[i]);
            mv.visitLdcInsn(paramName);
            mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
            mv.visitLdcInsn(parameter);
            mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
            InjectionPoint injectionPoint = BiInstantiatorBuilder.findFunctionCalls(parameters[i], injections);
            String getterName = ", parameter" + i + "=";
            String getterString = injectionPoint != null ? injectionPoint.functionType.toString() : "<null>";
            mv.visitLdcInsn(getterName);
            mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
            mv.visitLdcInsn(getterString);
            mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        }
        mv.visitLdcInsn("}");
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;", false);
        mv.visitInsn(176);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
    }

    private static InjectionPoint getFunctionCall(Parameter parameter, BiFunction biFunction) {
        if (biFunction.getClass().equals(BiFunctionGetter.class)) {
            Getter getter = ((BiFunctionGetter)biFunction).getGetter();
            Class<?> getterClass = getter.getClass();
            if (TypeHelper.isPrimitive(parameter.getType())) {
                Class<?> primitiveGetter = BiInstantiatorBuilder.getPrimitiveGetter(parameter.getType());
                if (primitiveGetter == null) {
                    throw new IllegalStateException("No primitive getter for primitive " + parameter.getType());
                }
                Type publicGetterClass = AsmUtils.findClosestPublicTypeExposing(getterClass, primitiveGetter);
                if (publicGetterClass != null) {
                    return new InjectionPoint(parameter, biFunction, true, "get" + BiInstantiatorBuilder.getPrimitiveMethodSuffix(parameter.getType()), publicGetterClass, true);
                }
            }
            Type publicGetterClass = AsmUtils.findClosestPublicTypeExposing(getterClass, Getter.class);
            return new InjectionPoint(parameter, biFunction, true, "get", publicGetterClass, false);
        }
        return new InjectionPoint(parameter, biFunction, false, "apply", biFunction.getClass(), false);
    }

    public static Type getTargetType(InstantiatorDefinition instantiatorDefinition) {
        switch (instantiatorDefinition.getType()) {
            case METHOD: {
                return ((Method)((ExecutableInstantiatorDefinition)instantiatorDefinition).getExecutable()).getGenericReturnType();
            }
            case CONSTRUCTOR: {
                return ((Constructor)((ExecutableInstantiatorDefinition)instantiatorDefinition).getExecutable()).getDeclaringClass();
            }
            case BUILDER: {
                return ((BuilderInstantiatorDefinition)instantiatorDefinition).getBuildMethod().getGenericReturnType();
            }
        }
        throw new IllegalArgumentException("Unsupported type " + (Object)((Object)instantiatorDefinition.getType()));
    }

    public static Class<?> getPrimitiveGetter(Class<?> propertyType) {
        return primitivesGetter.get(propertyType);
    }

    public static Method getMethod(Class<?> aClass, String name, int nbParam) {
        Method m = null;
        for (Method p : aClass.getDeclaredMethods()) {
            if (Modifier.isStatic(p.getModifiers()) || !p.getName().equals(name) || p.getParameterTypes() == null || p.getParameterTypes().length != nbParam || m != null && p.getModifiers() >= m.getModifiers()) continue;
            m = p;
        }
        return m;
    }

    static {
        primitivesGetter.put(Boolean.TYPE, BooleanGetter.class);
        primitivesGetter.put(Byte.TYPE, ByteGetter.class);
        primitivesGetter.put(Character.TYPE, CharacterGetter.class);
        primitivesGetter.put(Short.TYPE, ShortGetter.class);
        primitivesGetter.put(Integer.TYPE, IntGetter.class);
        primitivesGetter.put(Long.TYPE, LongGetter.class);
        primitivesGetter.put(Float.TYPE, FloatGetter.class);
        primitivesGetter.put(Double.TYPE, DoubleGetter.class);
    }

    static class InjectionPoint {
        final Parameter parameter;
        final BiFunction<?, ?, ?> function;
        final boolean isGetter;
        final String methodName;
        final Type functionType;
        final boolean isPrimitive;

        InjectionPoint(Parameter parameter, BiFunction<?, ?, ?> function, boolean isGetter, String methodName, Type functionType, boolean isPrimitive) {
            this.parameter = parameter;
            this.function = function;
            this.isGetter = isGetter;
            this.methodName = methodName;
            this.functionType = functionType;
            this.isPrimitive = isPrimitive;
        }

        public Method getMethod() {
            return BiInstantiatorBuilder.getMethod(TypeHelper.toClass((Type)this.functionType), this.methodName, this.isGetter ? 1 : 2);
        }
    }
}

