/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.simpleflatmapper.reflect.BuilderInstantiatorDefinition;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.Parameter;
import org.simpleflatmapper.reflect.instantiator.ExecutableInstantiatorDefinition;
import org.simpleflatmapper.reflect.setter.SetterHelper;
import org.simpleflatmapper.util.TypeHelper;

public class BuilderInstantiatorDefinitionFactory {
    public static List<InstantiatorDefinition> extractDefinitions(Type target) {
        ArrayList<InstantiatorDefinition> instantiatorDefinitions = new ArrayList<InstantiatorDefinition>();
        Class clazz = TypeHelper.toClass((Type)target);
        for (Method m : clazz.getDeclaredMethods()) {
            BuilderInstantiatorDefinition def;
            if (!BuilderInstantiatorDefinitionFactory.isPotentialBuilderMethod(m) || (def = BuilderInstantiatorDefinitionFactory.getDefinitionForBuilderFromMethod(m, target)) == null) continue;
            instantiatorDefinitions.add(def);
        }
        return instantiatorDefinitions;
    }

    private static boolean isPotentialBuilderMethod(Method m) {
        return Modifier.isStatic(m.getModifiers()) && m.getParameterTypes().length == 0 && !Void.TYPE.equals(m.getReturnType()) && !TypeHelper.areEquals(m.getReturnType(), m.getDeclaringClass());
    }

    private static BuilderInstantiatorDefinition getDefinitionForBuilderFromMethod(Method m, Type target) {
        if (Modifier.isStatic(m.getModifiers()) && Modifier.isPublic(m.getModifiers()) && m.getParameterTypes().length == 0 && !Void.TYPE.equals(m.getReturnType())) {
            return BuilderInstantiatorDefinitionFactory.getDefinitionForBuilder(m, target);
        }
        return null;
    }

    public static BuilderInstantiatorDefinition getDefinitionForBuilder(Member e, Type target) {
        ExecutableInstantiatorDefinition def = new ExecutableInstantiatorDefinition(e, new Parameter[0]);
        Type builderType = e instanceof Constructor ? ((Constructor)e).getDeclaringClass() : ((Method)e).getGenericReturnType();
        return BuilderInstantiatorDefinitionFactory.getDefinitionForBuilder(def, builderType, target);
    }

    private static BuilderInstantiatorDefinition getDefinitionForBuilder(ExecutableInstantiatorDefinition def, Type builderType, Type target) {
        HashMap<Parameter, Method> setters = new HashMap<Parameter, Method>();
        Method buildMethod = null;
        int i = 0;
        for (Method m : TypeHelper.toClass((Type)builderType).getMethods()) {
            if (Modifier.isStatic(m.getModifiers()) || Object.class == m.getDeclaringClass()) continue;
            Type returnType = m.getGenericReturnType();
            if ((TypeHelper.areEquals((Type)returnType, Void.TYPE) || TypeHelper.areEquals((Type)returnType, (Type)builderType)) && m.getParameterTypes().length == 1) {
                Parameter p = new Parameter(i++, SetterHelper.getPropertyNameFromMethodName(m.getName()), m.getParameterTypes()[0], m.getGenericParameterTypes()[0]);
                setters.put(p, m);
                continue;
            }
            if (!TypeHelper.areEquals((Type)returnType, (Type)target) || m.getParameterTypes().length != 0) continue;
            if (buildMethod != null) {
                throw new IllegalStateException("Duplicate potential build method " + buildMethod + " and " + m);
            }
            buildMethod = m;
        }
        if (!setters.isEmpty() || buildMethod != null) {
            return new BuilderInstantiatorDefinition(def, setters, buildMethod);
        }
        return null;
    }
}

