/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.util;

import java.io.IOException;
import java.io.Reader;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.locks.LockSupport;
import org.simpleflatmapper.util.RingBufferReader;

public class ParallelReader
extends Reader {
    private static final Executor DEFAULT_EXECUTOR_J8 = ForkJoinPool.getCommonPoolParallelism() > 1 ? ForkJoinPool.commonPool() : new Executor(){

        @Override
        public void execute(Runnable command) {
            new Thread(command).start();
        }
    };
    private static Executor DEFAULT_EXECUTOR_J6 = null;
    private static final Object lock = new Object();
    private static final WaitingStrategy DEFAULT_WAITING_STRATEGY = new WaitingStrategy(){

        @Override
        public int idle(int i) {
            LockSupport.parkNanos(1L);
            return i;
        }
    };
    private static final int DEFAULT_READ_BUFFER_SIZE = 8192;
    private static final int DEFAULT_RING_BUFFER_SIZE = 0x400000;
    private final RingBufferReader reader;

    public static Executor getDefaultExecutor() {
        return DEFAULT_EXECUTOR_J8;
    }

    private static Executor newDefaultExecutor() {
        int p = Runtime.getRuntime().availableProcessors();
        if (p <= 1) {
            return new Executor(){

                @Override
                public void execute(Runnable command) {
                    new Thread(command).start();
                }
            };
        }
        return Executors.newScheduledThreadPool(Math.min(p, Short.MAX_VALUE));
    }

    public ParallelReader(Reader reader) {
        this(reader, ParallelReader.getDefaultExecutor());
    }

    public ParallelReader(Reader reader, Executor executorService) {
        this(reader, executorService, 0x400000);
    }

    public ParallelReader(Reader reader, Executor executorService, int bufferSize) {
        this(reader, executorService, bufferSize, 8192);
    }

    public ParallelReader(Reader reader, Executor executorService, int bufferSize, int readBufferSize) {
        this(reader, executorService, bufferSize, readBufferSize, DEFAULT_WAITING_STRATEGY);
    }

    public ParallelReader(Reader reader, Executor executorService, int bufferSize, int readBufferSize, WaitingStrategy waitingStrategy) {
        this.reader = new RingBufferReader(reader, executorService, bufferSize, readBufferSize, waitingStrategy);
    }

    @Override
    public int read() throws IOException {
        return this.reader.read();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        return this.reader.read(cbuf, off, len);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public static interface WaitingStrategy {
        public int idle(int var1);
    }
}

