/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.util;

import java.io.IOException;
import java.io.Reader;
import java.util.concurrent.Executor;
import org.simpleflatmapper.util.Pad4;
import org.simpleflatmapper.util.ParallelReader;

final class RingBufferReader
extends Pad4 {
    public static final int L1_CACHE_LINE_SIZE = 64;
    private final Reader reader;
    private final DataProducer dataProducer;
    private final long bufferMask;
    private final int capacity;
    private final int tailPadding;
    private long tailCache;
    private final ParallelReader.WaitingStrategy waitingStrategy;

    public RingBufferReader(Reader reader, Executor executorService, int ringBufferSize, int readSize, ParallelReader.WaitingStrategy waitingStrategy) {
        this.capacity = 1 << 32 - Integer.numberOfLeadingZeros(ringBufferSize - 1);
        this.tailPadding = this.capacity <= 1024 ? 0 : 64;
        this.reader = reader;
        this.buffer = new char[this.capacity + 128];
        this.bufferMask = this.capacity - 1;
        this.waitingStrategy = waitingStrategy;
        this.dataProducer = new DataProducer(waitingStrategy, Math.max(Math.min(ringBufferSize / 8, readSize), 1));
        executorService.execute(this.dataProducer);
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        long currentHead = this.head;
        if (currentHead >= this.tailCache) {
            this.tailCache = this.tail;
            int i = 0;
            while (currentHead >= this.tailCache) {
                if (!this.run) {
                    if (this.dataProducer.exception != null) {
                        throw this.dataProducer.exception;
                    }
                    if (currentHead >= this.tail) {
                        return -1;
                    }
                }
                i = this.waitingStrategy.idle(i);
                this.tailCache = this.tail;
            }
        }
        int l = this.read(cbuf, off, len, currentHead, this.tailCache);
        this.head = currentHead + (long)l;
        return l;
    }

    public int read() throws IOException {
        long currentHead = this.head;
        if (currentHead >= this.tailCache) {
            this.tailCache = this.tail;
            int i = 0;
            while (currentHead >= this.tailCache) {
                if (!this.run) {
                    if (this.dataProducer.exception != null) {
                        throw this.dataProducer.exception;
                    }
                    if (currentHead >= this.tail) {
                        return -1;
                    }
                }
                i = this.waitingStrategy.idle(i);
                this.tailCache = this.tail;
            }
        }
        int headIndex = (int)(currentHead & this.bufferMask);
        char c = this.buffer[headIndex + 64];
        this.head = currentHead + 1L;
        return c;
    }

    private int read(char[] cbuf, int off, int len, long currentHead, long currentTail) {
        int headIndex = (int)(currentHead & this.bufferMask);
        int usedLength = (int)(currentTail - currentHead);
        int block1Length = Math.min(len, Math.min(usedLength, this.capacity - headIndex));
        int block2Length = Math.min(len, usedLength) - block1Length;
        System.arraycopy(this.buffer, headIndex + 64, cbuf, off, block1Length);
        System.arraycopy(this.buffer, 64, cbuf, off + block1Length, block2Length);
        return block1Length + block2Length;
    }

    public void close() throws IOException {
        this.dataProducer.stop();
        this.reader.close();
    }

    private final class DataProducer
    implements Runnable {
        private volatile IOException exception;
        private final ParallelReader.WaitingStrategy waitingStrategy;
        private int readSize;

        public DataProducer(ParallelReader.WaitingStrategy waitingStrategy, int readSize) {
            this.waitingStrategy = waitingStrategy;
            this.readSize = readSize;
        }

        @Override
        public void run() {
            ParallelReader.WaitingStrategy waitingStrategy = this.waitingStrategy;
            long currentTail = RingBufferReader.this.tail;
            long headCache = RingBufferReader.this.head;
            int readSize = this.readSize;
            long wrapPointOffest = RingBufferReader.this.capacity - RingBufferReader.this.tailPadding - readSize;
            while (RingBufferReader.this.run) {
                long wrapPoint = currentTail - wrapPointOffest;
                if (headCache <= wrapPoint) {
                    int i = 0;
                    headCache = RingBufferReader.this.head;
                    while (headCache <= wrapPoint) {
                        i = waitingStrategy.idle(i);
                        headCache = RingBufferReader.this.head;
                    }
                }
                currentTail = this.fillBuffer(currentTail, headCache, readSize);
            }
        }

        private long fillBuffer(long tail, long head, int readSize) {
            try {
                int block1Length;
                int used = (int)(tail - head);
                int writable = RingBufferReader.this.capacity - used - RingBufferReader.this.tailPadding;
                int tailIndex = (int)(tail & RingBufferReader.this.bufferMask);
                int endBlock1 = tailIndex + writable;
                if (endBlock1 > RingBufferReader.this.capacity) {
                    endBlock1 = RingBufferReader.this.capacity;
                }
                int l = readSize < (block1Length = endBlock1 - tailIndex) ? readSize : block1Length;
                int r = RingBufferReader.this.reader.read(RingBufferReader.this.buffer, tailIndex + 64, l);
                if (r != -1) {
                    RingBufferReader.this.tail = tail += (long)r;
                } else {
                    RingBufferReader.this.run = false;
                }
            }
            catch (IOException e) {
                this.exception = e;
                RingBufferReader.this.run = false;
            }
            return tail;
        }

        public void stop() {
            RingBufferReader.this.run = false;
        }
    }
}

