/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.lang.reflect.Array;
import org.simpleframework.xml.core.ArrayInstance;
import org.simpleframework.xml.core.Context;
import org.simpleframework.xml.core.ElementException;
import org.simpleframework.xml.core.Factory;
import org.simpleframework.xml.core.Instance;
import org.simpleframework.xml.core.InstantiationException;
import org.simpleframework.xml.strategy.Value;
import org.simpleframework.xml.stream.InputNode;

class ArrayFactory
extends Factory {
    public ArrayFactory(Context context, Class field) {
        super(context, field);
    }

    public Object getInstance() throws Exception {
        Class<?> type = this.field.getComponentType();
        if (type != null) {
            return Array.newInstance(type, 0);
        }
        return null;
    }

    public Instance getInstance(InputNode node) throws Exception {
        Value value = this.getOverride(node);
        if (value == null) {
            throw new ElementException("Array length required for %s", this.field);
        }
        Class type = value.getType();
        return this.getInstance(value, type);
    }

    private Instance getInstance(Value value, Class type) throws Exception {
        Class<?> expect = this.field.getComponentType();
        if (!expect.isAssignableFrom(type)) {
            throw new InstantiationException("Array of type %s cannot hold %s", expect, type);
        }
        return new ArrayInstance(value);
    }
}

