/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.email;

import java.util.List;
import javax.activation.DataSource;
import org.simplejavamail.email.AttachmentResource;
import org.simplejavamail.email.Email;
import org.simplejavamail.email.Recipient;

final class EqualsHelper {
    EqualsHelper() {
    }

    public static boolean equalsEmail(Email email1, Email email2) {
        if (email1.getFromRecipient() != null ? !EqualsHelper.isEqualRecipient(email1.getFromRecipient(), email2.getFromRecipient()) : email2.getFromRecipient() != null) {
            return false;
        }
        if (email1.getReplyToRecipient() != null ? !EqualsHelper.isEqualRecipient(email1.getReplyToRecipient(), email2.getReplyToRecipient()) : email2.getReplyToRecipient() != null) {
            return false;
        }
        if (email1.getText() != null ? !email1.getText().equals(email2.getText()) : email2.getText() != null) {
            return false;
        }
        if (email1.getTextHTML() != null ? !email1.getTextHTML().equals(email2.getTextHTML()) : email2.getTextHTML() != null) {
            return false;
        }
        if (email1.getSubject() != null ? !email1.getSubject().equals(email2.getSubject()) : email2.getSubject() != null) {
            return false;
        }
        if (!EqualsHelper.isEqualRecipientList(email1.getRecipients(), email2.getRecipients())) {
            return false;
        }
        if (!email1.getEmbeddedImages().containsAll(email2.getEmbeddedImages())) {
            return false;
        }
        if (!email1.getAttachments().containsAll(email2.getAttachments())) {
            return false;
        }
        if (!email1.getHeaders().equals(email2.getHeaders())) {
            return false;
        }
        if (email1.isUseDispositionNotificationTo() != email2.isUseDispositionNotificationTo()) {
            return false;
        }
        if (email1.isUseReturnReceiptTo() != email2.isUseReturnReceiptTo()) {
            return false;
        }
        if (email1.getDispositionNotificationTo() != null ? !email1.getDispositionNotificationTo().equals(email2.getDispositionNotificationTo()) : email2.getDispositionNotificationTo() != null) {
            return false;
        }
        return email1.getReturnReceiptTo() != null ? email1.getReturnReceiptTo().equals(email2.getReturnReceiptTo()) : email2.getReturnReceiptTo() == null;
    }

    private static boolean isEqualRecipientList(List<Recipient> recipients, List<Recipient> otherRecipients) {
        if (recipients.size() != otherRecipients.size()) {
            return false;
        }
        for (Recipient otherRecipient : otherRecipients) {
            if (EqualsHelper.containsRecipient(recipients, otherRecipient)) continue;
            return false;
        }
        return true;
    }

    private static boolean containsRecipient(List<Recipient> recipients, Recipient otherRecipient) {
        for (Recipient recipient : recipients) {
            if (!EqualsHelper.isEqualRecipient(recipient, otherRecipient)) continue;
            return true;
        }
        return false;
    }

    private static boolean isEqualRecipient(Recipient recipient, Recipient otherRecipient) {
        String otherName;
        String name = recipient != null ? recipient.getName() : null;
        String string = otherName = otherRecipient != null ? otherRecipient.getName() : null;
        if (name != null ? !name.equals(otherName) : otherName != null) {
            return false;
        }
        assert (otherRecipient != null);
        assert (recipient != null);
        if (!recipient.getAddress().equals(otherRecipient.getAddress())) {
            return false;
        }
        return recipient.getType() != null ? recipient.getType().equals(otherRecipient.getType()) : otherRecipient.getType() == null;
    }

    public static boolean equalsAttachmentResource(AttachmentResource resource1, AttachmentResource resource2) {
        if (resource1.getName() != null ? !resource1.getName().equals(resource2.getName()) : resource2.getName() != null) {
            return false;
        }
        return resource1.getDataSource() != null ? EqualsHelper.isEqualDataSource(resource1.getDataSource(), resource2.getDataSource()) : resource2.getDataSource() == null;
    }

    private static boolean isEqualDataSource(DataSource resource1, DataSource resource2) {
        if (resource1.getName() != null ? !resource1.getName().equals(resource2.getName()) : resource2.getName() != null) {
            return false;
        }
        return resource1.getContentType() != null ? resource1.getContentType().equals(resource2.getContentType()) : resource2.getContentType() == null;
    }
}

