/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.mailer.internal.socks.socks5client;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.simplejavamail.mailer.internal.socks.socks5client.SSLConfiguration;
import org.simplejavamail.mailer.internal.socks.socks5client.Socks5;

public class SSLSocks5
extends Socks5 {
    private final SSLConfiguration configuration;

    public SSLSocks5(InetSocketAddress address, SSLConfiguration configuration) {
        super(address);
        this.configuration = configuration;
    }

    private SSLSocks5(InetAddress address, int port, SSLConfiguration configuration) {
        super(address, port);
        this.configuration = configuration;
    }

    @Override
    public Socket createProxySocket(InetAddress address, int port) throws IOException {
        return this.configuration.getSSLSocketFactory().createSocket(address, port);
    }

    @Override
    public Socket createProxySocket() throws IOException {
        return this.configuration.getSSLSocketFactory().createSocket();
    }

    @Override
    public Socks5 copy() {
        return this.copyWithoutChainProxy().setChainProxy(this.getChainProxy());
    }

    private Socks5 copyWithoutChainProxy() {
        SSLSocks5 socks5 = new SSLSocks5(this.getInetAddress(), this.getPort(), this.configuration);
        socks5.setAlwaysResolveAddressLocally(this.isAlwaysResolveAddressLocally()).setCredentials(this.getCredentials()).setInetAddress(this.getInetAddress()).setPort(this.getPort()).setSocksAuthenticationHelper(this.getSocksAuthenticationHelper());
        return socks5;
    }
}

