/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.smimesupport;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.mail.internet.ContentType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.api.email.OriginalSmimeDetails;

public final class SmimeRecognitionUtil {
    private static final List<String> SMIME_MIMETYPES = Arrays.asList("application/pkcs7-mime", "application/x-pkcs7-mime");
    public static final String SMIME_ATTACHMENT_MESSAGE_ID = "<generated-for-smime-signed-attachment@simple-java-mail>";

    static boolean isSmimeContentType(@NotNull ContentType ct) {
        return SMIME_MIMETYPES.contains(ct.getBaseType()) || SmimeRecognitionUtil.isSmimeMultiPartSigned(ct.getBaseType(), ct.getParameter("protocol"));
    }

    public static boolean isGeneratedSmimeMessageId(@NotNull Map.Entry headerEntry) {
        return headerEntry.getKey().equals("Message-ID") && headerEntry.getValue().equals(SMIME_ATTACHMENT_MESSAGE_ID);
    }

    @NotNull
    public static OriginalSmimeDetails.SmimeMode determineSmimeMode(OriginalSmimeDetails d) {
        boolean signed;
        boolean encrypted = SMIME_MIMETYPES.contains(d.getSmimeMime()) && "enveloped-data".equals(d.getSmimeType());
        boolean bl = signed = !encrypted && (SMIME_MIMETYPES.contains(d.getSmimeMime()) || SmimeRecognitionUtil.isSmimeMultiPartSigned(d.getSmimeMime(), d.getSmimeProtocol()) || "signed-data".equals(d.getSmimeType()));
        return encrypted ? OriginalSmimeDetails.SmimeMode.ENCRYPTED : (signed ? OriginalSmimeDetails.SmimeMode.SIGNED : OriginalSmimeDetails.SmimeMode.PLAIN);
    }

    private static boolean isSmimeMultiPartSigned(@Nullable String mime, @Nullable String protocol) {
        return "multipart/signed".equals(mime) && (protocol == null || protocol.equals("application/pkcs7-signature") || protocol.equals("application/x-pkcs7-signature"));
    }
}

