/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.cli;

import java.io.PrintStream;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;

public class Logs {
    private DateTimeFormatter timeFormatter;
    private boolean debugEnabled = false;
    private PrintStream stdOut;
    private PrintStream stdErr;

    public Logs(PrintStream stdOut, PrintStream stdErr) {
        this.stdErr = stdErr;
        this.stdOut = stdOut;
        this.timeFormatter = DateTimeFormatter.ofPattern("HH:mm:ss.SSS");
    }

    public void setDebugEnabled(boolean debugEnabled) {
        this.debugEnabled = debugEnabled;
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public void debug(String message) {
        if (this.isDebugEnabled()) {
            LocalTime currentTime = LocalTime.now();
            String timestamp = currentTime.format(this.timeFormatter);
            this.stdOut.println(timestamp + " DEBUG: " + message);
        }
    }

    public void info(String message) {
        this.print(this.stdOut, "INFO: " + message);
    }

    public void warn(String message) {
        this.print(this.stdOut, "WARN: " + message);
    }

    public void error(String message) {
        this.print(this.stdErr, "ERROR: " + message);
    }

    public void error(String message, Throwable t) {
        this.print(this.stdErr, "ERROR: " + message);
        t.printStackTrace(this.stdErr);
    }

    private void print(PrintStream stream, String msg) {
        if (this.debugEnabled) {
            LocalTime currentTime = LocalTime.now();
            String timestamp = currentTime.format(this.timeFormatter);
            stream.println(timestamp + " " + msg);
        } else {
            stream.println(msg);
        }
    }
}

