/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.maven;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import org.apache.maven.plugin.logging.Log;

public class TimestampLogger
implements Log {
    private final DateTimeFormatter timeFormatter;
    private final Log log;

    public TimestampLogger(Log log) {
        this.log = log;
        this.timeFormatter = DateTimeFormatter.ofPattern("HH:mm:ss.SSS ");
    }

    public void debug(CharSequence content) {
        this.log.debug((CharSequence)(this.getCurrentTimeStamp() + content));
    }

    public void debug(CharSequence content, Throwable error) {
        this.log.debug((CharSequence)(this.getCurrentTimeStamp() + content), error);
    }

    public void info(CharSequence content) {
        this.log.info((CharSequence)(this.getCurrentTimeStamp() + content));
    }

    public void info(CharSequence content, Throwable error) {
        this.log.info((CharSequence)(this.getCurrentTimeStamp() + content), error);
    }

    public void warn(CharSequence content) {
        this.log.warn((CharSequence)(this.getCurrentTimeStamp() + content));
    }

    public void warn(CharSequence content, Throwable error) {
        this.log.warn((CharSequence)(this.getCurrentTimeStamp() + content), error);
    }

    public void error(CharSequence content) {
        this.log.error((CharSequence)(this.getCurrentTimeStamp() + content));
    }

    public void error(CharSequence content, Throwable error) {
        this.log.error((CharSequence)(this.getCurrentTimeStamp() + content), error);
    }

    private String getCurrentTimeStamp() {
        LocalTime currentTime = LocalTime.now();
        return currentTime.format(this.timeFormatter);
    }

    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    public void debug(Throwable error) {
        this.log.debug((CharSequence)this.getCurrentTimeStamp(), error);
    }

    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    public void info(Throwable error) {
        this.log.info((CharSequence)this.getCurrentTimeStamp(), error);
    }

    public boolean isWarnEnabled() {
        return this.log.isWarnEnabled();
    }

    public void warn(Throwable error) {
        this.log.warn((CharSequence)this.getCurrentTimeStamp(), error);
    }

    public boolean isErrorEnabled() {
        return this.log.isErrorEnabled();
    }

    public void error(Throwable error) {
        this.log.error((CharSequence)this.getCurrentTimeStamp(), error);
    }
}

