/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.bootstrap;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import org.sonar.api.utils.MessageException;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.scanner.bootstrap.GlobalAnalysisMode;
import org.sonarqube.ws.client.WsClient;
import org.sonarqube.ws.client.WsConnector;
import org.sonarqube.ws.client.WsRequest;
import org.sonarqube.ws.client.WsResponse;

public class ScannerWsClient {
    private static final Logger LOG = Loggers.get(ScannerWsClient.class);
    private final WsClient target;
    private final boolean hasCredentials;
    private final GlobalAnalysisMode globalMode;

    public ScannerWsClient(WsClient target, boolean hasCredentials, GlobalAnalysisMode globalMode) {
        this.target = target;
        this.hasCredentials = hasCredentials;
        this.globalMode = globalMode;
    }

    public WsResponse call(WsRequest request) {
        Preconditions.checkState((!this.globalMode.isMediumTest() ? 1 : 0) != 0, (Object)"No WS call should be made in medium test mode");
        Profiler profiler = Profiler.createIfDebug((Logger)LOG).start();
        WsResponse response = this.target.wsConnector().call(request);
        profiler.stopDebug(String.format("%s %d %s", request.getMethod(), response.code(), response.requestUrl()));
        this.failIfUnauthorized(response);
        return response;
    }

    public String baseUrl() {
        return this.target.wsConnector().baseUrl();
    }

    @VisibleForTesting
    WsConnector wsConnector() {
        return this.target.wsConnector();
    }

    private void failIfUnauthorized(WsResponse response) {
        int code = response.code();
        if (code == 401) {
            response.close();
            if (this.hasCredentials) {
                throw MessageException.of((String)String.format("Not authorized. Please check the properties %s and %s.", "sonar.login", "sonar.password"));
            }
            throw MessageException.of((String)String.format("Not authorized. Analyzing this project requires to be authenticated. Please provide the values of the properties %s and %s.", "sonar.login", "sonar.password"));
        }
        if (code == 403 || code == 400) {
            throw MessageException.of((String)ScannerWsClient.tryParseAsJsonError(response.content()));
        }
        response.failIfNotSuccessful();
    }

    public static String tryParseAsJsonError(String responseContent) {
        try {
            JsonParser parser = new JsonParser();
            JsonObject obj = parser.parse(responseContent).getAsJsonObject();
            JsonArray errors = obj.getAsJsonArray("errors");
            ArrayList<String> errorMessages = new ArrayList<String>();
            for (JsonElement e : errors) {
                errorMessages.add(e.getAsJsonObject().get("msg").getAsString());
            }
            return Joiner.on((String)", ").join(errorMessages);
        }
        catch (Exception e) {
            return responseContent;
        }
    }
}

