/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.cpd.deprecated;

import com.google.common.collect.Lists;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.duplications.block.BlockChunker;
import org.sonar.duplications.java.JavaStatementBuilder;
import org.sonar.duplications.java.JavaTokenProducer;
import org.sonar.duplications.statement.StatementChunker;
import org.sonar.duplications.token.TokenChunker;
import org.sonar.scanner.cpd.deprecated.CpdBlockIndexer;
import org.sonar.scanner.cpd.index.SonarCpdBlockIndex;

public class JavaCpdBlockIndexer
extends CpdBlockIndexer {
    private static final Logger LOG = Loggers.get(JavaCpdBlockIndexer.class);
    private static final int BLOCK_SIZE = 10;
    private final FileSystem fs;
    private final Configuration settings;
    private final SonarCpdBlockIndex index;

    public JavaCpdBlockIndexer(FileSystem fs, Configuration settings, SonarCpdBlockIndex index) {
        this.fs = fs;
        this.settings = settings;
        this.index = index;
    }

    @Override
    public boolean isLanguageSupported(String language) {
        return "java".equals(language);
    }

    @Override
    public void index(String languageKey) {
        String[] cpdExclusions = this.settings.getStringArray("sonar.cpd.exclusions");
        this.logExclusions(cpdExclusions);
        FilePredicates p = this.fs.predicates();
        ArrayList sourceFiles = Lists.newArrayList((Iterable)this.fs.inputFiles(p.and(new FilePredicate[]{p.hasType(InputFile.Type.MAIN), p.hasLanguage(languageKey), p.doesNotMatchPathPatterns(cpdExclusions)})));
        if (sourceFiles.isEmpty()) {
            return;
        }
        this.createIndex(sourceFiles);
    }

    private void createIndex(Iterable<InputFile> sourceFiles) {
        TokenChunker tokenChunker = JavaTokenProducer.build();
        StatementChunker statementChunker = JavaStatementBuilder.build();
        BlockChunker blockChunker = new BlockChunker(10);
        for (InputFile inputFile : sourceFiles) {
            List blocks;
            List statements;
            LOG.debug("Populating index from {}", (Object)inputFile);
            String resourceEffectiveKey = ((DefaultInputFile)inputFile).key();
            try (InputStream is = inputFile.inputStream();
                 InputStreamReader reader = new InputStreamReader(is, inputFile.charset());){
                statements = statementChunker.chunk(tokenChunker.chunk((Reader)reader));
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException("Cannot find file " + inputFile.file(), e);
            }
            catch (IOException e) {
                throw new IllegalStateException("Exception handling file: " + inputFile.file(), e);
            }
            try {
                blocks = blockChunker.chunk(resourceEffectiveKey, statements);
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot process file " + inputFile.file(), e);
            }
            this.index.insert(inputFile, blocks);
        }
    }
}

