/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.cpd.index;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.duplications.block.Block;
import org.sonar.duplications.block.ByteArray;
import org.sonar.duplications.index.AbstractCloneIndex;
import org.sonar.duplications.index.CloneIndex;
import org.sonar.duplications.index.PackedMemoryCloneIndex;
import org.sonar.scanner.cpd.CpdSettings;
import org.sonar.scanner.protocol.output.FileStructure;
import org.sonar.scanner.protocol.output.ScannerReport;
import org.sonar.scanner.report.ReportPublisher;

public class SonarCpdBlockIndex
extends AbstractCloneIndex {
    private static final Logger LOG = Loggers.get(SonarCpdBlockIndex.class);
    private final CloneIndex mem = new PackedMemoryCloneIndex();
    private final ReportPublisher publisher;
    private final Set<InputFile> indexedFiles = new HashSet<InputFile>();
    private final CpdSettings settings;

    public SonarCpdBlockIndex(ReportPublisher publisher, CpdSettings settings) {
        this.publisher = publisher;
        this.settings = settings;
    }

    public void insert(InputFile inputFile, Collection<Block> blocks) {
        if (this.settings.isCrossProjectDuplicationEnabled()) {
            int id = ((DefaultInputFile)inputFile).batchId();
            if (this.publisher.getWriter().hasComponentData(FileStructure.Domain.CPD_TEXT_BLOCKS, id)) {
                throw new UnsupportedOperationException("Trying to save CPD tokens twice for the same file is not supported: " + inputFile.absolutePath());
            }
            ScannerReport.CpdTextBlock.Builder builder = ScannerReport.CpdTextBlock.newBuilder();
            this.publisher.getWriter().writeCpdTextBlocks(id, (Iterable)blocks.stream().map(block -> {
                builder.clear();
                builder.setStartLine(block.getStartLine());
                builder.setEndLine(block.getEndLine());
                builder.setStartTokenIndex(block.getStartUnit());
                builder.setEndTokenIndex(block.getEndUnit());
                builder.setHash(block.getBlockHash().toHexString());
                return builder.build();
            }).collect(Collectors.toList()));
        }
        for (Block block2 : blocks) {
            this.mem.insert(block2);
        }
        if (blocks.isEmpty()) {
            LOG.debug("Not enough content in '{}' to have CPD blocks, it will not be part of the duplication detection", (Object)inputFile.relativePath());
        }
        this.indexedFiles.add(inputFile);
    }

    public int noIndexedFiles() {
        return this.indexedFiles.size();
    }

    public boolean isIndexed(InputFile inputFile) {
        return this.indexedFiles.contains(inputFile);
    }

    public Collection<Block> getByInputFile(String resourceKey) {
        return this.mem.getByResourceId(resourceKey);
    }

    public Collection<Block> getBySequenceHash(ByteArray hash) {
        return this.mem.getBySequenceHash(hash);
    }

    public Collection<Block> getByResourceId(String resourceId) {
        throw new UnsupportedOperationException();
    }

    public void insert(Block block) {
        throw new UnsupportedOperationException();
    }

    public Iterator<PackedMemoryCloneIndex.ResourceBlocks> iterator() {
        return this.mem.iterator();
    }

    public int noResources() {
        return this.mem.noResources();
    }
}

