/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.issue;

import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.sonar.api.issue.Issue;
import org.sonar.api.issue.ProjectIssues;
import org.sonar.scanner.issue.IssueCache;
import org.sonar.scanner.issue.TrackedIssueAdapter;
import org.sonar.scanner.issue.tracking.TrackedIssue;

public class DefaultProjectIssues
implements ProjectIssues {
    private static final Predicate<TrackedIssue> RESOLVED = new ResolvedPredicate(true);
    private static final Predicate<TrackedIssue> NOT_RESOLVED = new ResolvedPredicate(false);
    private final IssueCache cache;

    public DefaultProjectIssues(IssueCache cache) {
        this.cache = cache;
    }

    public Iterable<Issue> issues() {
        return StreamSupport.stream(this.cache.all().spliterator(), false).filter(NOT_RESOLVED).map(TrackedIssueAdapter::new).collect(Collectors.toList());
    }

    public Iterable<Issue> resolvedIssues() {
        return StreamSupport.stream(this.cache.all().spliterator(), false).filter(RESOLVED).map(TrackedIssueAdapter::new).collect(Collectors.toList());
    }

    private static class ResolvedPredicate
    implements Predicate<TrackedIssue> {
        private final boolean resolved;

        private ResolvedPredicate(boolean resolved) {
            this.resolved = resolved;
        }

        @Override
        public boolean test(@Nullable TrackedIssue issue) {
            if (issue != null) {
                return this.resolved ? issue.resolution() != null : issue.resolution() == null;
            }
            return false;
        }
    }
}

