/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.issue.ignore.pattern;

import com.google.common.base.Preconditions;
import java.util.LinkedHashSet;
import java.util.Set;

public class LineRange {
    private int from;
    private int to;

    public LineRange(int line) {
        this(line, line);
    }

    public LineRange(int from, int to) {
        Preconditions.checkArgument((from <= to ? 1 : 0) != 0, (String)"Line range is not valid: %s must be greater or equal than %s", (Object[])new Object[]{to, from});
        this.from = from;
        this.to = to;
    }

    public boolean in(int lineId) {
        return this.from <= lineId && lineId <= this.to;
    }

    public Set<Integer> toLines() {
        LinkedHashSet<Integer> lines = new LinkedHashSet<Integer>(this.to - this.from + 1);
        for (int index = this.from; index <= this.to; ++index) {
            lines.add(index);
        }
        return lines;
    }

    public int from() {
        return this.from;
    }

    public int to() {
        return this.to;
    }

    public String toString() {
        return "[" + this.from + "-" + this.to + "]";
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.from;
        result = 31 * result + this.to;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return !this.fieldsDiffer((LineRange)obj);
    }

    private boolean fieldsDiffer(LineRange other) {
        return this.from != other.from || this.to != other.to;
    }
}

