/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.issue.ignore.scanner;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.internal.charhandler.CharHandler;
import org.sonar.scanner.issue.ignore.pattern.LineRange;
import org.sonar.scanner.issue.ignore.pattern.PatternMatcher;
import org.sonar.scanner.issue.ignore.scanner.IssueExclusionsLoader;

public class IssueExclusionsRegexpScanner
extends CharHandler {
    private static final Logger LOG = LoggerFactory.getLogger(IssueExclusionsLoader.class);
    private final StringBuilder sb = new StringBuilder();
    private final List<Pattern> allFilePatterns;
    private final List<IssueExclusionsLoader.DoubleRegexpMatcher> blockMatchers;
    private final String componentKey;
    private final PatternMatcher patternMatcher;
    private int lineIndex = 1;
    private List<LineExclusion> lineExclusions = new ArrayList<LineExclusion>();
    private LineExclusion currentLineExclusion = null;
    private int fileLength = 0;
    private IssueExclusionsLoader.DoubleRegexpMatcher currentMatcher;

    IssueExclusionsRegexpScanner(String componentKey, List<Pattern> allFilePatterns, List<IssueExclusionsLoader.DoubleRegexpMatcher> blockMatchers, PatternMatcher patternMatcher) {
        this.allFilePatterns = allFilePatterns;
        this.blockMatchers = blockMatchers;
        this.patternMatcher = patternMatcher;
        this.componentKey = componentKey;
        String relativePath = StringUtils.substringAfterLast((String)componentKey, (String)":");
        LOG.info("'{}' generating issue exclusions", (Object)relativePath);
    }

    public void handleIgnoreEoL(char c) {
        this.sb.append(c);
    }

    public void newLine() {
        this.processLine(this.sb.toString());
        this.sb.setLength(0);
        ++this.lineIndex;
    }

    public void eof() {
        this.processLine(this.sb.toString());
        if (this.currentMatcher != null && !this.currentMatcher.hasSecondPattern()) {
            this.endExclusion(this.lineIndex + 1);
        }
        this.fileLength = this.lineIndex;
        if (!this.lineExclusions.isEmpty()) {
            Set<LineRange> lineRanges = this.convertLineExclusionsToLineRanges();
            LOG.debug("- Line exclusions found: {}", lineRanges);
            this.patternMatcher.addPatternToExcludeLines(this.componentKey, lineRanges);
        }
    }

    private void processLine(String line) {
        if (line.trim().length() == 0) {
            return;
        }
        for (Pattern pattern : this.allFilePatterns) {
            if (!pattern.matcher(line).find()) continue;
            this.patternMatcher.addPatternToExcludeResource(this.componentKey);
            LOG.debug("- Exclusion pattern '{}': every issue in this file will be ignored.", (Object)pattern);
            return;
        }
        this.checkDoubleRegexps(line, this.lineIndex);
    }

    private Set<LineRange> convertLineExclusionsToLineRanges() {
        HashSet<LineRange> lineRanges = new HashSet<LineRange>(this.lineExclusions.size());
        for (LineExclusion lineExclusion : this.lineExclusions) {
            lineRanges.add(lineExclusion.toLineRange(this.fileLength));
        }
        return lineRanges;
    }

    private void checkDoubleRegexps(String line, int lineIndex) {
        if (this.currentMatcher == null) {
            for (IssueExclusionsLoader.DoubleRegexpMatcher matcher : this.blockMatchers) {
                if (!matcher.matchesFirstPattern(line)) continue;
                this.startExclusion(lineIndex);
                this.currentMatcher = matcher;
                break;
            }
        } else if (this.currentMatcher.matchesSecondPattern(line)) {
            this.endExclusion(lineIndex);
            this.currentMatcher = null;
        }
    }

    private void startExclusion(int lineIndex) {
        this.currentLineExclusion = new LineExclusion(lineIndex);
        this.lineExclusions.add(this.currentLineExclusion);
    }

    private void endExclusion(int lineIndex) {
        this.currentLineExclusion.setEnd(lineIndex);
        this.currentLineExclusion = null;
    }

    private static class LineExclusion {
        private int start;
        private int end;

        LineExclusion(int start) {
            this.start = start;
            this.end = -1;
        }

        void setEnd(int end) {
            this.end = end;
        }

        public LineRange toLineRange(int fileLength) {
            return new LineRange(this.start, this.end == -1 ? fileLength : this.end);
        }
    }
}

