/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.issue.tracking;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.ObjectUtils;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.FileMetadata;

public final class FileHashes {
    private final String[] hashes;
    private final Multimap<String, Integer> linesByHash;

    private FileHashes(String[] hashes, Multimap<String, Integer> linesByHash) {
        this.hashes = hashes;
        this.linesByHash = linesByHash;
    }

    public static FileHashes create(String[] hashes) {
        int size = hashes.length;
        LinkedHashMultimap linesByHash = LinkedHashMultimap.create();
        for (int i = 0; i < size; ++i) {
            linesByHash.put((Object)hashes[i], (Object)(i + 1));
        }
        return new FileHashes(hashes, (Multimap<String, Integer>)linesByHash);
    }

    public static FileHashes create(InputFile f) {
        byte[][] hashes = new byte[f.lines()][];
        FileMetadata.computeLineHashesForIssueTracking((InputFile)f, (lineIdx, hash) -> {
            hashes[lineIdx - 1] = hash;
        });
        int size = hashes.length;
        LinkedHashMultimap linesByHash = LinkedHashMultimap.create();
        String[] hexHashes = new String[size];
        for (int i = 0; i < size; ++i) {
            String hash2;
            hexHashes[i] = hash2 = hashes[i] != null ? Hex.encodeHexString((byte[])hashes[i]) : "";
            linesByHash.put((Object)hash2, (Object)(i + 1));
        }
        return new FileHashes(hexHashes, (Multimap<String, Integer>)linesByHash);
    }

    public int length() {
        return this.hashes.length;
    }

    public Collection<Integer> getLinesForHash(String hash) {
        return this.linesByHash.get((Object)hash);
    }

    public String[] hashes() {
        return this.hashes;
    }

    public String getHash(int line) {
        return (String)ObjectUtils.defaultIfNull((Object)this.hashes[line - 1], (Object)"");
    }
}

