/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.issue.tracking;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.internal.DefaultInputComponent;
import org.sonar.core.util.CloseableIterator;
import org.sonar.scanner.ProjectAnalysisInfo;
import org.sonar.scanner.issue.IssueCache;
import org.sonar.scanner.issue.IssueTransformer;
import org.sonar.scanner.issue.tracking.LocalIssueTracking;
import org.sonar.scanner.issue.tracking.TrackedIssue;
import org.sonar.scanner.protocol.output.ScannerReport;
import org.sonar.scanner.protocol.output.ScannerReportReader;
import org.sonar.scanner.report.ReportPublisher;
import org.sonar.scanner.scan.filesystem.InputComponentStore;
import org.sonar.scanner.util.ProgressReport;

@ScannerSide
public class IssueTransition {
    private final IssueCache issueCache;
    private final InputComponentStore inputComponentStore;
    private final ReportPublisher reportPublisher;
    private final Date analysisDate;
    @Nullable
    private final LocalIssueTracking localIssueTracking;

    public IssueTransition(InputComponentStore inputComponentCache, ProjectAnalysisInfo projectAnalysisInfo, IssueCache issueCache, ReportPublisher reportPublisher, @Nullable LocalIssueTracking localIssueTracking) {
        this.inputComponentStore = inputComponentCache;
        this.issueCache = issueCache;
        this.reportPublisher = reportPublisher;
        this.localIssueTracking = localIssueTracking;
        this.analysisDate = projectAnalysisInfo.analysisDate();
    }

    public IssueTransition(InputComponentStore inputComponentCache, ProjectAnalysisInfo projectAnalysisInfo, IssueCache issueCache, ReportPublisher reportPublisher) {
        this(inputComponentCache, projectAnalysisInfo, issueCache, reportPublisher, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        if (this.localIssueTracking != null) {
            this.localIssueTracking.init();
        }
        ScannerReportReader reader = new ScannerReportReader(this.reportPublisher.getReportDir().toFile());
        int nbComponents = this.inputComponentStore.all().size();
        if (nbComponents == 0) {
            return;
        }
        ProgressReport progressReport = new ProgressReport("issue-tracking-report", TimeUnit.SECONDS.toMillis(10L));
        progressReport.start("Performing issue tracking");
        int count = 0;
        try {
            for (InputComponent component : this.inputComponentStore.all()) {
                this.trackIssues(reader, (DefaultInputComponent)component);
                progressReport.message(++count + "/" + nbComponents + " components tracked");
            }
        }
        finally {
            progressReport.stop(count + "/" + nbComponents + " components tracked");
        }
    }

    public void trackIssues(ScannerReportReader reader, DefaultInputComponent component) {
        LinkedList<ScannerReport.Issue> rawIssues = new LinkedList<ScannerReport.Issue>();
        try {
            CloseableIterator it = reader.readComponentIssues(component.batchId());
            Object object = null;
            try {
                while (it.hasNext()) {
                    rawIssues.add((ScannerReport.Issue)it.next());
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (it != null) {
                    if (object != null) {
                        try {
                            it.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        it.close();
                    }
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't read issues for " + component.key(), e);
        }
        List<TrackedIssue> trackedIssues = this.localIssueTracking != null ? this.localIssueTracking.trackIssues((InputComponent)component, rawIssues, this.analysisDate) : IssueTransition.doTransition(rawIssues, (InputComponent)component);
        for (TrackedIssue issue : trackedIssues) {
            this.issueCache.put(issue);
        }
    }

    private static List<TrackedIssue> doTransition(List<ScannerReport.Issue> rawIssues, InputComponent component) {
        ArrayList<TrackedIssue> issues = new ArrayList<TrackedIssue>(rawIssues.size());
        for (ScannerReport.Issue issue : rawIssues) {
            issues.add(IssueTransformer.toTrackedIssue(component, issue, null));
        }
        return issues;
    }
}

