/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.phases;

import org.sonar.api.batch.SensorContext;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.InputModule;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.api.batch.fs.internal.InputModuleHierarchy;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.scanner.events.BatchStepEvent;
import org.sonar.scanner.events.EventBus;
import org.sonar.scanner.issue.ignore.scanner.IssueExclusionsLoader;
import org.sonar.scanner.phases.CoverageExclusions;
import org.sonar.scanner.phases.InitializersExecutor;
import org.sonar.scanner.phases.PostJobsExecutor;
import org.sonar.scanner.phases.ProjectAnalysisEvent;
import org.sonar.scanner.phases.SensorsExecutor;
import org.sonar.scanner.rule.QProfileVerifier;
import org.sonar.scanner.scan.filesystem.DefaultModuleFileSystem;
import org.sonar.scanner.scan.filesystem.FileIndexer;

public abstract class AbstractPhaseExecutor {
    private static final Logger LOG = Loggers.get(AbstractPhaseExecutor.class);
    private final EventBus eventBus;
    private final PostJobsExecutor postJobsExecutor;
    private final InitializersExecutor initializersExecutor;
    private final SensorsExecutor sensorsExecutor;
    private final SensorContext sensorContext;
    private final DefaultModuleFileSystem fs;
    private final QProfileVerifier profileVerifier;
    private final IssueExclusionsLoader issueExclusionsLoader;
    private final InputModuleHierarchy hierarchy;
    private final FileIndexer fileIndexer;
    private final CoverageExclusions coverageExclusions;

    public AbstractPhaseExecutor(InitializersExecutor initializersExecutor, PostJobsExecutor postJobsExecutor, SensorsExecutor sensorsExecutor, SensorContext sensorContext, InputModuleHierarchy hierarchy, EventBus eventBus, DefaultModuleFileSystem fs, QProfileVerifier profileVerifier, IssueExclusionsLoader issueExclusionsLoader, FileIndexer fileIndexer, CoverageExclusions coverageExclusions) {
        this.postJobsExecutor = postJobsExecutor;
        this.initializersExecutor = initializersExecutor;
        this.sensorsExecutor = sensorsExecutor;
        this.sensorContext = sensorContext;
        this.eventBus = eventBus;
        this.fs = fs;
        this.profileVerifier = profileVerifier;
        this.issueExclusionsLoader = issueExclusionsLoader;
        this.hierarchy = hierarchy;
        this.fileIndexer = fileIndexer;
        this.coverageExclusions = coverageExclusions;
    }

    public final void execute(DefaultInputModule module) {
        this.eventBus.fireEvent(new ProjectAnalysisEvent(module, true));
        this.executeInitializersPhase();
        this.indexFs();
        this.profileVerifier.execute();
        this.initIssueExclusions();
        this.initCoverageExclusions();
        this.sensorsExecutor.execute(this.sensorContext);
        this.afterSensors();
        if (this.hierarchy.isRoot((InputModule)module)) {
            this.executeOnRoot();
            this.postJobsExecutor.execute(this.sensorContext);
        }
        this.eventBus.fireEvent(new ProjectAnalysisEvent(module, false));
    }

    private void initCoverageExclusions() {
        if (this.coverageExclusions.shouldExecute()) {
            String stepName = "Init coverage exclusions";
            this.eventBus.fireEvent(new BatchStepEvent(stepName, true));
            this.coverageExclusions.log();
            for (InputFile inputFile : this.fs.inputFiles(this.fs.predicates().all())) {
                boolean excluded = this.coverageExclusions.isExcluded((DefaultInputFile)inputFile);
                if (!excluded) continue;
                ((DefaultInputFile)inputFile).setExcludedForCoverage(true);
                LOG.debug("File {} excluded for coverage", (Object)inputFile);
            }
            this.eventBus.fireEvent(new BatchStepEvent(stepName, false));
        }
    }

    protected void afterSensors() {
    }

    protected abstract void executeOnRoot();

    private void initIssueExclusions() {
        if (this.issueExclusionsLoader.shouldExecute()) {
            String stepName = "Init issue exclusions";
            this.eventBus.fireEvent(new BatchStepEvent(stepName, true));
            for (InputFile inputFile : this.fs.inputFiles(this.fs.predicates().all())) {
                this.issueExclusionsLoader.addMulticriteriaPatterns(((DefaultInputFile)inputFile).getModuleRelativePath(), inputFile.key());
            }
            this.eventBus.fireEvent(new BatchStepEvent(stepName, false));
        }
    }

    private void indexFs() {
        String stepName = "Index filesystem";
        this.eventBus.fireEvent(new BatchStepEvent(stepName, true));
        this.fileIndexer.index();
        this.eventBus.fireEvent(new BatchStepEvent(stepName, false));
    }

    private void executeInitializersPhase() {
        this.initializersExecutor.execute();
    }
}

