/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.phases;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.WildcardPattern;

@Immutable
public class CoverageExclusions {
    private static final Logger LOG = LoggerFactory.getLogger(CoverageExclusions.class);
    private Collection<WildcardPattern> exclusionPatterns;

    public CoverageExclusions(Configuration settings) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String pattern : settings.getStringArray("sonar.coverage.exclusions")) {
            builder.add((Object)WildcardPattern.create((String)pattern));
        }
        this.exclusionPatterns = builder.build();
    }

    void log() {
        CoverageExclusions.log("Excluded sources for coverage: ", this.exclusionPatterns);
    }

    boolean isExcluded(DefaultInputFile file) {
        boolean found = false;
        Iterator<WildcardPattern> iterator = this.exclusionPatterns.iterator();
        while (!found && iterator.hasNext()) {
            found = iterator.next().match(file.getModuleRelativePath());
        }
        return found;
    }

    private static void log(String title, Collection<WildcardPattern> patterns) {
        if (!patterns.isEmpty()) {
            LOG.info(title);
            for (WildcardPattern pattern : patterns) {
                LOG.info("  " + pattern);
            }
        }
    }

    public boolean shouldExecute() {
        return !this.exclusionPatterns.isEmpty();
    }
}

