/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.phases;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.batch.fs.internal.InputModuleHierarchy;
import org.sonar.scanner.events.BatchStepEvent;
import org.sonar.scanner.events.EventBus;
import org.sonar.scanner.issue.ignore.scanner.IssueExclusionsLoader;
import org.sonar.scanner.issue.tracking.IssueTransition;
import org.sonar.scanner.phases.AbstractPhaseExecutor;
import org.sonar.scanner.phases.CoverageExclusions;
import org.sonar.scanner.phases.InitializersExecutor;
import org.sonar.scanner.phases.PostJobsExecutor;
import org.sonar.scanner.phases.SensorsExecutor;
import org.sonar.scanner.rule.QProfileVerifier;
import org.sonar.scanner.scan.filesystem.DefaultModuleFileSystem;
import org.sonar.scanner.scan.filesystem.FileIndexer;
import org.sonar.scanner.scan.report.IssuesReports;

public final class IssuesPhaseExecutor
extends AbstractPhaseExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(IssuesPhaseExecutor.class);
    private final EventBus eventBus;
    private final IssuesReports issuesReport;
    private final IssueTransition localIssueTracking;

    public IssuesPhaseExecutor(InitializersExecutor initializersExecutor, PostJobsExecutor postJobsExecutor, SensorsExecutor sensorsExecutor, SensorContext sensorContext, EventBus eventBus, IssuesReports jsonReport, DefaultModuleFileSystem fs, QProfileVerifier profileVerifier, IssueExclusionsLoader issueExclusionsLoader, IssueTransition localIssueTracking, InputModuleHierarchy moduleHierarchy, FileIndexer fileIndexer, CoverageExclusions coverageExclusions) {
        super(initializersExecutor, postJobsExecutor, sensorsExecutor, sensorContext, moduleHierarchy, eventBus, fs, profileVerifier, issueExclusionsLoader, fileIndexer, coverageExclusions);
        this.eventBus = eventBus;
        this.issuesReport = jsonReport;
        this.localIssueTracking = localIssueTracking;
    }

    @Override
    protected void executeOnRoot() {
        this.localIssueTracking();
        this.issuesReport();
        LOG.info("ANALYSIS SUCCESSFUL");
    }

    private void localIssueTracking() {
        String stepName = "Local Issue Tracking";
        this.eventBus.fireEvent(new BatchStepEvent(stepName, true));
        this.localIssueTracking.execute();
        this.eventBus.fireEvent(new BatchStepEvent(stepName, false));
    }

    private void issuesReport() {
        String stepName = "Issues Reports";
        this.eventBus.fireEvent(new BatchStepEvent(stepName, true));
        this.issuesReport.execute();
        this.eventBus.fireEvent(new BatchStepEvent(stepName, false));
    }
}

