/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.phases;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.PostJob;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.scanner.bootstrap.ScannerExtensionDictionnary;
import org.sonar.scanner.events.EventBus;
import org.sonar.scanner.phases.PostJobExecutionEvent;
import org.sonar.scanner.phases.PostJobPhaseEvent;
import org.sonar.scanner.util.ScannerUtils;

@ScannerSide
public class PostJobsExecutor {
    private static final Logger LOG = Loggers.get(PostJobsExecutor.class);
    private final ScannerExtensionDictionnary selector;
    private final DefaultInputModule module;
    private final EventBus eventBus;

    public PostJobsExecutor(ScannerExtensionDictionnary selector, DefaultInputModule module, EventBus eventBus) {
        this.selector = selector;
        this.module = module;
        this.eventBus = eventBus;
    }

    public void execute(SensorContext context) {
        Collection<PostJob> postJobs = this.selector.select(PostJob.class, this.module, true, null);
        this.eventBus.fireEvent(new PostJobPhaseEvent(new ArrayList<PostJob>(postJobs), true));
        this.execute(context, postJobs);
        this.eventBus.fireEvent(new PostJobPhaseEvent(new ArrayList<PostJob>(postJobs), false));
    }

    private void execute(SensorContext context, Collection<PostJob> postJobs) {
        PostJobsExecutor.logPostJobs(postJobs);
        Project project = new Project(this.module);
        for (PostJob postJob : postJobs) {
            LOG.info("Executing post-job {}", (Object)ScannerUtils.describe(postJob));
            this.eventBus.fireEvent(new PostJobExecutionEvent(postJob, true));
            postJob.executeOn(project, context);
            this.eventBus.fireEvent(new PostJobExecutionEvent(postJob, false));
        }
    }

    private static void logPostJobs(Collection<PostJob> postJobs) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(() -> "Post-jobs : " + StringUtils.join((Collection)postJobs, (String)" -> "));
        }
    }
}

