/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.phases;

import org.sonar.api.batch.SensorContext;
import org.sonar.api.batch.fs.internal.InputModuleHierarchy;
import org.sonar.scanner.cpd.CpdExecutor;
import org.sonar.scanner.events.BatchStepEvent;
import org.sonar.scanner.events.EventBus;
import org.sonar.scanner.issue.ignore.scanner.IssueExclusionsLoader;
import org.sonar.scanner.phases.AbstractPhaseExecutor;
import org.sonar.scanner.phases.CoverageExclusions;
import org.sonar.scanner.phases.InitializersExecutor;
import org.sonar.scanner.phases.PostJobsExecutor;
import org.sonar.scanner.phases.SensorsExecutor;
import org.sonar.scanner.report.ReportPublisher;
import org.sonar.scanner.rule.QProfileVerifier;
import org.sonar.scanner.scan.filesystem.DefaultModuleFileSystem;
import org.sonar.scanner.scan.filesystem.FileIndexer;
import org.sonar.scanner.scm.ScmPublisher;

public final class PublishPhaseExecutor
extends AbstractPhaseExecutor {
    private final EventBus eventBus;
    private final ReportPublisher reportPublisher;
    private final CpdExecutor cpdExecutor;
    private final ScmPublisher scm;

    public PublishPhaseExecutor(InitializersExecutor initializersExecutor, PostJobsExecutor postJobsExecutor, SensorsExecutor sensorsExecutor, SensorContext sensorContext, EventBus eventBus, ReportPublisher reportPublisher, DefaultModuleFileSystem fs, QProfileVerifier profileVerifier, IssueExclusionsLoader issueExclusionsLoader, CpdExecutor cpdExecutor, ScmPublisher scm, InputModuleHierarchy hierarchy, FileIndexer fileIndexer, CoverageExclusions coverageExclusions) {
        super(initializersExecutor, postJobsExecutor, sensorsExecutor, sensorContext, hierarchy, eventBus, fs, profileVerifier, issueExclusionsLoader, fileIndexer, coverageExclusions);
        this.eventBus = eventBus;
        this.reportPublisher = reportPublisher;
        this.cpdExecutor = cpdExecutor;
        this.scm = scm;
    }

    @Override
    protected void executeOnRoot() {
        this.computeDuplications();
        this.publishReportJob();
    }

    @Override
    protected void afterSensors() {
        this.scm.publish();
    }

    private void computeDuplications() {
        String stepName = "Computing duplications";
        this.eventBus.fireEvent(new BatchStepEvent(stepName, true));
        this.cpdExecutor.execute();
        this.eventBus.fireEvent(new BatchStepEvent(stepName, false));
    }

    private void publishReportJob() {
        String stepName = "Publish report";
        this.eventBus.fireEvent(new BatchStepEvent(stepName, true));
        this.reportPublisher.execute();
        this.eventBus.fireEvent(new BatchStepEvent(stepName, false));
    }
}

