/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.report;

import java.util.Map;
import java.util.Optional;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.api.batch.fs.internal.InputModuleHierarchy;
import org.sonar.api.config.Configuration;
import org.sonar.scanner.ProjectAnalysisInfo;
import org.sonar.scanner.bootstrap.ScannerPlugin;
import org.sonar.scanner.bootstrap.ScannerPluginRepository;
import org.sonar.scanner.cpd.CpdSettings;
import org.sonar.scanner.protocol.output.ScannerReport;
import org.sonar.scanner.protocol.output.ScannerReportWriter;
import org.sonar.scanner.report.ReportPublisherStep;
import org.sonar.scanner.rule.ModuleQProfiles;
import org.sonar.scanner.rule.QProfile;
import org.sonar.scanner.scan.branch.BranchConfiguration;
import org.sonar.scanner.scan.branch.BranchType;

public class MetadataPublisher
implements ReportPublisherStep {
    private final Configuration settings;
    private final ModuleQProfiles qProfiles;
    private final ProjectAnalysisInfo projectAnalysisInfo;
    private final InputModuleHierarchy moduleHierarchy;
    private final CpdSettings cpdSettings;
    private final ScannerPluginRepository pluginRepository;
    private final BranchConfiguration branchConfiguration;

    public MetadataPublisher(ProjectAnalysisInfo projectAnalysisInfo, InputModuleHierarchy moduleHierarchy, Configuration settings, ModuleQProfiles qProfiles, CpdSettings cpdSettings, ScannerPluginRepository pluginRepository, BranchConfiguration branchConfiguration) {
        this.projectAnalysisInfo = projectAnalysisInfo;
        this.moduleHierarchy = moduleHierarchy;
        this.settings = settings;
        this.qProfiles = qProfiles;
        this.cpdSettings = cpdSettings;
        this.pluginRepository = pluginRepository;
        this.branchConfiguration = branchConfiguration;
    }

    @Override
    public void publish(ScannerReportWriter writer) {
        DefaultInputModule rootProject = this.moduleHierarchy.root();
        ScannerReport.Metadata.Builder builder = ScannerReport.Metadata.newBuilder().setAnalysisDate(this.projectAnalysisInfo.analysisDate().getTime()).setProjectKey(rootProject.key()).setCrossProjectDuplicationActivated(this.cpdSettings.isCrossProjectDuplicationEnabled()).setRootComponentRef(rootProject.batchId());
        this.settings.get("sonar.organization").ifPresent(arg_0 -> ((ScannerReport.Metadata.Builder)builder).setOrganizationKey(arg_0));
        if (this.branchConfiguration.branchName() != null) {
            builder.setBranchName(this.branchConfiguration.branchName());
            builder.setBranchType(MetadataPublisher.toProtobufBranchType(this.branchConfiguration.branchType()));
            String branchTarget = this.branchConfiguration.branchTarget();
            if (branchTarget != null) {
                builder.setMergeBranchName(branchTarget);
            }
        }
        Optional.ofNullable(rootProject.getBranch()).ifPresent(arg_0 -> ((ScannerReport.Metadata.Builder)builder).setDeprecatedBranch(arg_0));
        for (QProfile qProfile : this.qProfiles.findAll()) {
            builder.getMutableQprofilesPerLanguage().put(qProfile.getLanguage(), ScannerReport.Metadata.QProfile.newBuilder().setKey(qProfile.getKey()).setLanguage(qProfile.getLanguage()).setName(qProfile.getName()).setRulesUpdatedAt(qProfile.getRulesUpdatedAt().getTime()).build());
        }
        for (Map.Entry entry : this.pluginRepository.getPluginsByKey().entrySet()) {
            builder.getMutablePluginsByKey().put(entry.getKey(), ScannerReport.Metadata.Plugin.newBuilder().setKey((String)entry.getKey()).setUpdatedAt(((ScannerPlugin)entry.getValue()).getUpdatedAt()).build());
        }
        writer.writeMetadata(builder.build());
    }

    private static ScannerReport.Metadata.BranchType toProtobufBranchType(BranchType branchType) {
        if (branchType == BranchType.LONG) {
            return ScannerReport.Metadata.BranchType.LONG;
        }
        return ScannerReport.Metadata.BranchType.SHORT;
    }
}

