/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.report;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.scanner.protocol.output.ScannerReportWriter;
import org.sonar.scanner.report.ReportPublisherStep;
import org.sonar.scanner.scan.filesystem.InputComponentStore;

public class SourcePublisher
implements ReportPublisherStep {
    private final InputComponentStore componentCache;

    public SourcePublisher(InputComponentStore componentStore) {
        this.componentCache = componentStore;
    }

    @Override
    public void publish(ScannerReportWriter writer) {
        for (DefaultInputFile inputFile : this.componentCache.allFilesToPublish()) {
            File iofile = writer.getSourceFile(inputFile.batchId());
            try {
                FileOutputStream output = new FileOutputStream(iofile);
                Throwable throwable = null;
                try {
                    InputStream in = inputFile.inputStream();
                    Throwable throwable2 = null;
                    try {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(in, inputFile.charset()));
                        Throwable throwable3 = null;
                        try {
                            SourcePublisher.writeSource(reader, output, inputFile.lines());
                        }
                        catch (Throwable throwable4) {
                            throwable3 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (reader == null) continue;
                            if (throwable3 != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable3.addSuppressed(throwable5);
                                }
                                continue;
                            }
                            reader.close();
                        }
                    }
                    catch (Throwable throwable6) {
                        throwable2 = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (in == null) continue;
                        if (throwable2 != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable7) {
                                throwable2.addSuppressed(throwable7);
                            }
                            continue;
                        }
                        in.close();
                    }
                }
                catch (Throwable throwable8) {
                    throwable = throwable8;
                    throw throwable8;
                }
                finally {
                    if (output == null) continue;
                    if (throwable != null) {
                        try {
                            output.close();
                        }
                        catch (Throwable throwable9) {
                            throwable.addSuppressed(throwable9);
                        }
                        continue;
                    }
                    output.close();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to store file source in the report", e);
            }
        }
    }

    private static void writeSource(BufferedReader reader, FileOutputStream output, int lines) throws IOException {
        int line = 0;
        String lineStr = reader.readLine();
        while (lineStr != null) {
            IOUtils.write((String)lineStr, (OutputStream)output, (Charset)StandardCharsets.UTF_8);
            if (++line < lines) {
                IOUtils.write((String)"\n", (OutputStream)output, (Charset)StandardCharsets.UTF_8);
            }
            lineStr = reader.readLine();
        }
    }
}

