/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.repository;

import com.google.common.base.Throwables;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.utils.MessageException;
import org.sonar.scanner.bootstrap.ScannerWsClient;
import org.sonar.scanner.repository.FileData;
import org.sonar.scanner.repository.ProjectRepositories;
import org.sonar.scanner.repository.ProjectRepositoriesLoader;
import org.sonar.scanner.util.ScannerUtils;
import org.sonarqube.ws.WsBatch;
import org.sonarqube.ws.client.GetRequest;
import org.sonarqube.ws.client.HttpException;
import org.sonarqube.ws.client.WsRequest;
import org.sonarqube.ws.client.WsResponse;

public class DefaultProjectRepositoriesLoader
implements ProjectRepositoriesLoader {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultProjectRepositoriesLoader.class);
    private static final String BATCH_PROJECT_URL = "/batch/project.protobuf";
    private ScannerWsClient wsClient;

    public DefaultProjectRepositoriesLoader(ScannerWsClient wsClient) {
        this.wsClient = wsClient;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ProjectRepositories load(String projectKey, boolean issuesMode, @Nullable String branchBase) {
        GetRequest request = new GetRequest(DefaultProjectRepositoriesLoader.getUrl(projectKey, issuesMode, branchBase));
        try (WsResponse response = this.wsClient.call((WsRequest)request);){
            InputStream is = response.contentStream();
            ProjectRepositories projectRepositories = DefaultProjectRepositoriesLoader.processStream(is, projectKey);
            return projectRepositories;
        }
        catch (RuntimeException e) {
            if (DefaultProjectRepositoriesLoader.shouldThrow(e)) {
                throw e;
            }
            LOG.debug("Project repository not available - continuing without it");
            return new ProjectRepositories();
        }
    }

    private static String getUrl(String projectKey, boolean issuesMode, @Nullable String branchBase) {
        StringBuilder builder = new StringBuilder();
        builder.append(BATCH_PROJECT_URL).append("?key=").append(ScannerUtils.encodeForUrl(projectKey));
        if (issuesMode) {
            builder.append("&issues_mode=true");
        }
        if (branchBase != null) {
            builder.append("&branch=").append(branchBase);
        }
        return builder.toString();
    }

    private static boolean shouldThrow(Exception e) {
        for (Throwable t : Throwables.getCausalChain((Throwable)e)) {
            if (t instanceof HttpException) {
                HttpException http = (HttpException)t;
                return http.code() != 404;
            }
            if (!(t instanceof MessageException)) continue;
            return true;
        }
        return false;
    }

    private static ProjectRepositories processStream(InputStream is, String projectKey) {
        try {
            WsBatch.WsProjectResponse response = WsBatch.WsProjectResponse.parseFrom((InputStream)is);
            HashBasedTable fileDataTable = HashBasedTable.create();
            HashBasedTable settings = HashBasedTable.create();
            Map settingsByModule = response.getSettingsByModule();
            for (Map.Entry e1 : settingsByModule.entrySet()) {
                for (Map.Entry e2 : ((WsBatch.WsProjectResponse.Settings)e1.getValue()).getSettings().entrySet()) {
                    settings.put(e1.getKey(), e2.getKey(), e2.getValue());
                }
            }
            Map fileDataByModuleAndPath = response.getFileDataByModuleAndPath();
            for (Map.Entry e1 : fileDataByModuleAndPath.entrySet()) {
                for (Map.Entry e2 : ((WsBatch.WsProjectResponse.FileDataByPath)e1.getValue()).getFileDataByPath().entrySet()) {
                    FileData fd = new FileData(((WsBatch.WsProjectResponse.FileData)e2.getValue()).getHash(), ((WsBatch.WsProjectResponse.FileData)e2.getValue()).getRevision());
                    fileDataTable.put(e1.getKey(), e2.getKey(), (Object)fd);
                }
            }
            ProjectRepositories projectRepositories = new ProjectRepositories((Table<String, String, String>)settings, (Table<String, String, FileData>)fileDataTable, new Date(response.getLastAnalysisDate()));
            return projectRepositories;
        }
        catch (IOException e) {
            throw new IllegalStateException("Couldn't load project repository for " + projectKey, e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }
}

