/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.repository;

import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import java.util.Date;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.scanner.repository.FileData;

@Immutable
public class ProjectRepositories {
    private final ImmutableTable<String, String, String> settingsByModule;
    private final ImmutableTable<String, String, FileData> fileDataByModuleAndPath;
    private final Date lastAnalysisDate;
    private final boolean exists;

    public ProjectRepositories() {
        this.exists = false;
        this.settingsByModule = new ImmutableTable.Builder().build();
        this.fileDataByModuleAndPath = new ImmutableTable.Builder().build();
        this.lastAnalysisDate = null;
    }

    public ProjectRepositories(Table<String, String, String> settingsByModule, Table<String, String, FileData> fileDataByModuleAndPath, @Nullable Date lastAnalysisDate) {
        this.settingsByModule = ImmutableTable.copyOf(settingsByModule);
        this.fileDataByModuleAndPath = ImmutableTable.copyOf(fileDataByModuleAndPath);
        this.lastAnalysisDate = lastAnalysisDate;
        this.exists = true;
    }

    public boolean exists() {
        return this.exists;
    }

    public Map<String, FileData> fileDataByPath(String moduleKey) {
        return this.fileDataByModuleAndPath.row((Object)moduleKey);
    }

    public Table<String, String, FileData> fileDataByModuleAndPath() {
        return this.fileDataByModuleAndPath;
    }

    public boolean moduleExists(String moduleKey) {
        return this.settingsByModule.containsRow((Object)moduleKey);
    }

    public Map<String, String> settings(String moduleKey) {
        return this.settingsByModule.row((Object)moduleKey);
    }

    @CheckForNull
    public FileData fileData(String projectKeyWithBranch, String path) {
        return (FileData)this.fileDataByModuleAndPath.get((Object)projectKeyWithBranch, (Object)path);
    }

    @CheckForNull
    public Date lastAnalysisDate() {
        return this.lastAnalysisDate;
    }
}

