/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan;

import java.io.IOException;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.picocontainer.Startable;
import org.sonar.api.batch.fs.internal.InputModuleHierarchy;
import org.sonar.home.cache.DirectoryLock;
import org.sonar.home.cache.Logger;
import org.sonar.scanner.bootstrap.Slf4jLogger;

public class ProjectLock
implements Startable {
    private final DirectoryLock lock;

    public ProjectLock(InputModuleHierarchy moduleHierarchy) {
        Path directory = moduleHierarchy.root().getWorkDir();
        try {
            if (!directory.toFile().exists()) {
                Files.createDirectories(directory, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create work directory", e);
        }
        this.lock = new DirectoryLock(directory.toAbsolutePath(), (Logger)new Slf4jLogger());
    }

    public void tryLock() {
        try {
            if (!this.lock.tryLock()) {
                ProjectLock.failAlreadyInProgress(null);
            }
        }
        catch (OverlappingFileLockException e) {
            ProjectLock.failAlreadyInProgress(e);
        }
    }

    private static void failAlreadyInProgress(Exception e) {
        throw new IllegalStateException("Another SonarQube analysis is already in progress for this project", e);
    }

    public void stop() {
        this.lock.unlock();
    }

    public void start() {
    }
}

