/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan.filesystem;

import java.nio.file.Path;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultIndexedFile;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.api.batch.fs.internal.InputModuleHierarchy;
import org.sonar.api.batch.fs.internal.SensorStrategy;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.PathUtils;
import org.sonar.scanner.scan.filesystem.BatchIdGenerator;
import org.sonar.scanner.scan.filesystem.MetadataGenerator;
import org.sonar.scanner.scan.filesystem.ModuleFileSystemInitializer;

public class InputFileBuilder {
    public static final String PRELOAD_FILE_METADATA_KEY = "sonar.preloadFileMetadata";
    private final String moduleKey;
    private final Path moduleBaseDir;
    private final BatchIdGenerator idGenerator;
    private final MetadataGenerator metadataGenerator;
    private final boolean preloadMetadata;
    private final ModuleFileSystemInitializer moduleFileSystemInitializer;
    private final Path projectBaseDir;
    private final SensorStrategy sensorStrategy;

    public InputFileBuilder(DefaultInputModule module, MetadataGenerator metadataGenerator, BatchIdGenerator idGenerator, Configuration settings, ModuleFileSystemInitializer moduleFileSystemInitializer, InputModuleHierarchy hierarchy, SensorStrategy sensorStrategy) {
        this.sensorStrategy = sensorStrategy;
        this.projectBaseDir = hierarchy.root().getBaseDir();
        this.moduleFileSystemInitializer = moduleFileSystemInitializer;
        this.moduleKey = module.key();
        this.moduleBaseDir = module.getBaseDir();
        this.metadataGenerator = metadataGenerator;
        this.idGenerator = idGenerator;
        this.preloadMetadata = settings.getBoolean(PRELOAD_FILE_METADATA_KEY).orElse(false);
    }

    DefaultInputFile create(InputFile.Type type, Path absolutePath, @Nullable String language) {
        DefaultIndexedFile indexedFile = new DefaultIndexedFile(absolutePath, this.moduleKey, PathUtils.sanitize((String)this.projectBaseDir.relativize(absolutePath).toString()), PathUtils.sanitize((String)this.moduleBaseDir.relativize(absolutePath).toString()), type, language, this.idGenerator.get().intValue(), this.sensorStrategy);
        DefaultInputFile inputFile = new DefaultInputFile(indexedFile, f -> this.metadataGenerator.setMetadata((DefaultInputFile)f, this.moduleFileSystemInitializer.defaultEncoding()));
        if (language != null) {
            inputFile.setPublished(true);
        }
        return inputFile;
    }

    void checkMetadata(DefaultInputFile inputFile) {
        if (this.preloadMetadata) {
            inputFile.checkMetadata();
        }
    }
}

