/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan.filesystem;

import com.google.common.annotations.VisibleForTesting;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.api.batch.fs.internal.FileMetadata;
import org.sonar.api.batch.fs.internal.Metadata;
import org.sonar.scanner.issue.ignore.scanner.IssueExclusionsLoader;
import org.sonar.scanner.scan.filesystem.CharsetDetector;
import org.sonar.scanner.scan.filesystem.StatusDetection;

public class MetadataGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(MetadataGenerator.class);
    @VisibleForTesting
    static final Charset UTF_32BE = Charset.forName("UTF-32BE");
    @VisibleForTesting
    static final Charset UTF_32LE = Charset.forName("UTF-32LE");
    private final StatusDetection statusDetection;
    private final FileMetadata fileMetadata;
    private final DefaultInputModule inputModule;
    private final IssueExclusionsLoader exclusionsScanner;

    public MetadataGenerator(DefaultInputModule inputModule, StatusDetection statusDetection, FileMetadata fileMetadata, IssueExclusionsLoader exclusionsScanner) {
        this.inputModule = inputModule;
        this.statusDetection = statusDetection;
        this.fileMetadata = fileMetadata;
        this.exclusionsScanner = exclusionsScanner;
    }

    public void setMetadata(DefaultInputFile inputFile, Charset defaultEncoding) {
        CharsetDetector charsetDetector = new CharsetDetector(inputFile.path(), defaultEncoding);
        try {
            Charset charset;
            if (charsetDetector.run()) {
                charset = charsetDetector.charset();
            } else {
                LOG.debug("Failed to detect a valid charset for file '{}'. Using default charset.", (Object)inputFile);
                charset = defaultEncoding;
            }
            InputStream is = charsetDetector.inputStream();
            inputFile.setCharset(charset);
            Metadata metadata = this.fileMetadata.readMetadata(is, charset, inputFile.absolutePath(), this.exclusionsScanner.createCharHandlerFor(inputFile.key()));
            inputFile.setMetadata(metadata);
            inputFile.setStatus(this.statusDetection.status(this.inputModule.definition().getKeyWithBranch(), inputFile, metadata.hash()));
            LOG.debug("'{}' generated metadata {} with charset '{}'", new Object[]{inputFile, inputFile.type() == InputFile.Type.TEST ? "as test " : "", charset});
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

