/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan.filesystem;

import java.util.function.Predicate;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.fs.internal.OperatorPredicate;
import org.sonar.api.batch.fs.internal.StatusPredicate;
import org.sonar.scanner.scan.filesystem.StatusDetection;

public class SameInputFilePredicate
implements Predicate<InputFile> {
    private final StatusDetection statusDetection;
    private final String moduleKeyWithBranch;
    private final FilePredicate currentPredicate;

    public SameInputFilePredicate(FilePredicate currentPredicate, StatusDetection statusDetection, String moduleKeyWithBranch) {
        this.currentPredicate = currentPredicate;
        this.statusDetection = statusDetection;
        this.moduleKeyWithBranch = moduleKeyWithBranch;
    }

    @Override
    public boolean test(InputFile inputFile) {
        if (SameInputFilePredicate.hasExplicitFilterOnStatus(this.currentPredicate)) {
            return true;
        }
        InputFile.Status status = this.statusDetection.getStatusWithoutMetadata(this.moduleKeyWithBranch, (DefaultInputFile)inputFile);
        if (status != null) {
            return status != InputFile.Status.SAME;
        }
        return inputFile.status() != InputFile.Status.SAME;
    }

    static boolean hasExplicitFilterOnStatus(FilePredicate predicate) {
        if (predicate instanceof StatusPredicate) {
            return true;
        }
        if (predicate instanceof OperatorPredicate) {
            return ((OperatorPredicate)predicate).operands().stream().anyMatch(SameInputFilePredicate::hasExplicitFilterOnStatus);
        }
        return false;
    }
}

