/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan.filesystem;

import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.scanner.repository.FileData;
import org.sonar.scanner.repository.ProjectRepositories;
import org.sonar.scanner.scm.ScmChangedFiles;

@Immutable
public class StatusDetection {
    private final ProjectRepositories projectRepositories;
    private final ScmChangedFiles scmChangedFiles;

    public StatusDetection(ProjectRepositories projectSettings, ScmChangedFiles scmChangedFiles) {
        this.projectRepositories = projectSettings;
        this.scmChangedFiles = scmChangedFiles;
    }

    InputFile.Status status(String projectKeyWithBranch, DefaultInputFile inputFile, String hash) {
        FileData fileDataPerPath = this.projectRepositories.fileData(projectKeyWithBranch, inputFile.relativePath());
        if (fileDataPerPath == null) {
            return this.checkChanged(InputFile.Status.ADDED, inputFile);
        }
        String previousHash = fileDataPerPath.hash();
        if (StringUtils.equals((String)hash, (String)previousHash)) {
            return InputFile.Status.SAME;
        }
        if (StringUtils.isEmpty((String)previousHash)) {
            return this.checkChanged(InputFile.Status.ADDED, inputFile);
        }
        return this.checkChanged(InputFile.Status.CHANGED, inputFile);
    }

    @CheckForNull
    public InputFile.Status getStatusWithoutMetadata(String projectKeyWithBranch, DefaultInputFile inputFile) {
        FileData fileDataPerPath = this.projectRepositories.fileData(projectKeyWithBranch, inputFile.relativePath());
        if (fileDataPerPath == null) {
            return this.checkChanged(InputFile.Status.ADDED, inputFile);
        }
        String previousHash = fileDataPerPath.hash();
        if (StringUtils.isEmpty((String)previousHash)) {
            return this.checkChanged(InputFile.Status.ADDED, inputFile);
        }
        return null;
    }

    private InputFile.Status checkChanged(InputFile.Status status, DefaultInputFile inputFile) {
        if (!this.scmChangedFiles.verifyChanged(inputFile.path())) {
            return InputFile.Status.SAME;
        }
        return status;
    }
}

