/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scm;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;
import org.picocontainer.Startable;
import org.sonar.api.Properties;
import org.sonar.api.Property;
import org.sonar.api.PropertyType;
import org.sonar.api.batch.AnalysisMode;
import org.sonar.api.batch.InstantiationStrategy;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.batch.fs.internal.InputModuleHierarchy;
import org.sonar.api.batch.scm.ScmProvider;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

@Properties(value={@Property(key="sonar.scm.forceReloadAll", defaultValue="false", name="Force reloading of SCM information for all files", description="By default only files modified since previous analysis are inspected. Set this parameter to true to force the reloading.", category="scm", project=false, module=false, global=false, type=PropertyType.BOOLEAN)})
@InstantiationStrategy(value="PER_BATCH")
@ScannerSide
public class ScmConfiguration
implements Startable {
    private static final Logger LOG = Loggers.get(ScmConfiguration.class);
    public static final String FORCE_RELOAD_KEY = "sonar.scm.forceReloadAll";
    private final Configuration settings;
    private final Map<String, ScmProvider> providerPerKey = new LinkedHashMap<String, ScmProvider>();
    private final AnalysisMode analysisMode;
    private final InputModuleHierarchy moduleHierarchy;
    private ScmProvider provider;

    public ScmConfiguration(InputModuleHierarchy moduleHierarchy, AnalysisMode analysisMode, Configuration settings, ScmProvider ... providers) {
        this.moduleHierarchy = moduleHierarchy;
        this.analysisMode = analysisMode;
        this.settings = settings;
        for (ScmProvider scmProvider : providers) {
            this.providerPerKey.put(scmProvider.key(), scmProvider);
        }
    }

    public ScmConfiguration(InputModuleHierarchy moduleHierarchy, AnalysisMode analysisMode, Configuration settings) {
        this(moduleHierarchy, analysisMode, settings, new ScmProvider[0]);
    }

    public void start() {
        if (this.analysisMode.isIssues()) {
            return;
        }
        if (this.isDisabled()) {
            LOG.debug("SCM Step is disabled by configuration");
            return;
        }
        if (this.settings.hasKey("sonar.scm.provider")) {
            this.settings.get("sonar.scm.provider").ifPresent(this::setProviderIfSupported);
        } else {
            this.autodetection();
            if (this.provider == null) {
                this.considerOldScmUrl();
            }
            if (this.provider == null) {
                LOG.warn("SCM provider autodetection failed. No SCM provider claims to support this project. Please use sonar.scm.provider to define SCM of your project.");
            }
        }
    }

    private void setProviderIfSupported(String forcedProviderKey) {
        if (!this.providerPerKey.containsKey(forcedProviderKey)) {
            String supportedProviders = this.providerPerKey.isEmpty() ? "No SCM provider installed" : "Supported SCM providers are " + this.providerPerKey.keySet().stream().collect(Collectors.joining(","));
            throw new IllegalArgumentException("SCM provider was set to \"" + forcedProviderKey + "\" but no SCM provider found for this key. " + supportedProviders);
        }
        this.provider = this.providerPerKey.get(forcedProviderKey);
    }

    private void considerOldScmUrl() {
        this.settings.get("sonar.links.scm_dev").ifPresent(url -> {
            String[] split;
            if (StringUtils.startsWith((String)url, (String)"scm:") && (split = url.split(":")).length > 1) {
                this.setProviderIfSupported(split[1]);
            }
        });
    }

    private void autodetection() {
        for (ScmProvider installedProvider : this.providerPerKey.values()) {
            if (!installedProvider.supports(this.moduleHierarchy.root().getBaseDir().toFile())) continue;
            if (this.provider == null) {
                this.provider = installedProvider;
                continue;
            }
            throw new IllegalStateException("SCM provider autodetection failed. Both " + this.provider.key() + " and " + installedProvider.key() + " claim to support this project. Please use " + "sonar.scm.provider" + " to define SCM of your project.");
        }
    }

    @CheckForNull
    public ScmProvider provider() {
        return this.provider;
    }

    public boolean isDisabled() {
        return this.settings.getBoolean("sonar.scm.disabled").orElse(false);
    }

    public boolean forceReloadAll() {
        return this.settings.getBoolean(FORCE_RELOAD_KEY).orElse(false);
    }

    public void stop() {
    }
}

