/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scm;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.InstantiationStrategy;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.api.batch.scm.BlameCommand;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.scanner.protocol.output.ScannerReport;
import org.sonar.scanner.protocol.output.ScannerReportWriter;
import org.sonar.scanner.report.ReportPublisher;
import org.sonar.scanner.repository.FileData;
import org.sonar.scanner.repository.ProjectRepositories;
import org.sonar.scanner.scan.branch.BranchConfiguration;
import org.sonar.scanner.scan.filesystem.DefaultModuleFileSystem;
import org.sonar.scanner.scan.filesystem.ModuleInputComponentStore;
import org.sonar.scanner.scm.DefaultBlameInput;
import org.sonar.scanner.scm.DefaultBlameOutput;
import org.sonar.scanner.scm.ScmConfiguration;

@InstantiationStrategy(value="PER_PROJECT")
@ScannerSide
public final class ScmPublisher {
    private static final Logger LOG = Loggers.get(ScmPublisher.class);
    private final DefaultInputModule inputModule;
    private final ScmConfiguration configuration;
    private final ProjectRepositories projectRepositories;
    private final ModuleInputComponentStore componentStore;
    private final DefaultModuleFileSystem fs;
    private final ScannerReportWriter writer;
    private final BranchConfiguration branchConfiguration;

    public ScmPublisher(DefaultInputModule inputModule, ScmConfiguration configuration, ProjectRepositories projectRepositories, ModuleInputComponentStore componentStore, DefaultModuleFileSystem fs, ReportPublisher reportPublisher, BranchConfiguration branchConfiguration) {
        this.inputModule = inputModule;
        this.configuration = configuration;
        this.projectRepositories = projectRepositories;
        this.componentStore = componentStore;
        this.fs = fs;
        this.branchConfiguration = branchConfiguration;
        this.writer = reportPublisher.getWriter();
    }

    public void publish() {
        if (this.configuration.isDisabled()) {
            LOG.info("SCM Publisher is disabled");
            return;
        }
        if (this.configuration.provider() == null) {
            LOG.info("No SCM system was detected. You can use the 'sonar.scm.provider' property to explicitly specify it.");
            return;
        }
        List<InputFile> filesToBlame = this.collectFilesToBlame(this.writer);
        if (!filesToBlame.isEmpty()) {
            String key = this.configuration.provider().key();
            LOG.info("SCM provider for this project is: " + key);
            DefaultBlameOutput output = new DefaultBlameOutput(this.writer, filesToBlame);
            try {
                this.configuration.provider().blameCommand().blame((BlameCommand.BlameInput)new DefaultBlameInput((FileSystem)this.fs, filesToBlame), (BlameCommand.BlameOutput)output);
            }
            catch (Exception e) {
                output.finish(false);
                throw e;
            }
            output.finish(true);
        }
    }

    private List<InputFile> collectFilesToBlame(ScannerReportWriter writer) {
        if (this.configuration.forceReloadAll()) {
            LOG.warn("Forced reloading of SCM data for all files.");
        }
        LinkedList<InputFile> filesToBlame = new LinkedList<InputFile>();
        for (InputFile f : this.componentStore.inputFiles()) {
            DefaultInputFile inputFile = (DefaultInputFile)f;
            if (!inputFile.isPublished()) continue;
            if (this.configuration.forceReloadAll() || f.status() != InputFile.Status.SAME) {
                ScmPublisher.addIfNotEmpty(filesToBlame, f);
                continue;
            }
            if (this.branchConfiguration.isShortLivingBranch()) continue;
            FileData fileData = this.projectRepositories.fileData(this.inputModule.definition().getKeyWithBranch(), inputFile.getModuleRelativePath());
            if (StringUtils.isEmpty((String)fileData.revision())) {
                ScmPublisher.addIfNotEmpty(filesToBlame, f);
                continue;
            }
            ScmPublisher.askToCopyDataFromPreviousAnalysis((DefaultInputFile)f, writer);
        }
        return filesToBlame;
    }

    private static void askToCopyDataFromPreviousAnalysis(DefaultInputFile f, ScannerReportWriter writer) {
        ScannerReport.Changesets.Builder scmBuilder = ScannerReport.Changesets.newBuilder();
        scmBuilder.setComponentRef(f.batchId());
        scmBuilder.setCopyFromPrevious(true);
        writer.writeComponentChangesets(scmBuilder.build());
    }

    private static void addIfNotEmpty(List<InputFile> filesToBlame, InputFile f) {
        if (!f.isEmpty()) {
            filesToBlame.add(f);
        }
    }
}

