/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.sensor;

import java.io.Serializable;
import javax.annotation.concurrent.ThreadSafe;
import org.sonar.api.SonarRuntime;
import org.sonar.api.batch.AnalysisMode;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.InputModule;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.coverage.NewCoverage;
import org.sonar.api.batch.sensor.coverage.internal.DefaultCoverage;
import org.sonar.api.batch.sensor.cpd.NewCpdTokens;
import org.sonar.api.batch.sensor.cpd.internal.DefaultCpdTokens;
import org.sonar.api.batch.sensor.error.NewAnalysisError;
import org.sonar.api.batch.sensor.highlighting.NewHighlighting;
import org.sonar.api.batch.sensor.highlighting.internal.DefaultHighlighting;
import org.sonar.api.batch.sensor.internal.SensorStorage;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.internal.DefaultIssue;
import org.sonar.api.batch.sensor.measure.NewMeasure;
import org.sonar.api.batch.sensor.measure.internal.DefaultMeasure;
import org.sonar.api.batch.sensor.symbol.NewSymbolTable;
import org.sonar.api.batch.sensor.symbol.internal.DefaultSymbolTable;
import org.sonar.api.config.Configuration;
import org.sonar.api.config.Settings;
import org.sonar.api.utils.Version;
import org.sonar.scanner.scan.branch.BranchConfiguration;
import org.sonar.scanner.sensor.noop.NoOpNewAnalysisError;
import org.sonar.scanner.sensor.noop.NoOpNewCoverage;
import org.sonar.scanner.sensor.noop.NoOpNewCpdTokens;
import org.sonar.scanner.sensor.noop.NoOpNewHighlighting;
import org.sonar.scanner.sensor.noop.NoOpNewSymbolTable;

@ThreadSafe
public class DefaultSensorContext
implements SensorContext {
    private static final NoOpNewHighlighting NO_OP_NEW_HIGHLIGHTING = new NoOpNewHighlighting();
    private static final NoOpNewSymbolTable NO_OP_NEW_SYMBOL_TABLE = new NoOpNewSymbolTable();
    static final NoOpNewCpdTokens NO_OP_NEW_CPD_TOKENS = new NoOpNewCpdTokens();
    private static final NoOpNewAnalysisError NO_OP_NEW_ANALYSIS_ERROR = new NoOpNewAnalysisError();
    static final NoOpNewCoverage NO_OP_NEW_COVERAGE = new NoOpNewCoverage();
    private final Settings mutableSettings;
    private final FileSystem fs;
    private final ActiveRules activeRules;
    private final SensorStorage sensorStorage;
    private final AnalysisMode analysisMode;
    private final InputModule module;
    private final SonarRuntime sonarRuntime;
    private final Configuration config;
    private final BranchConfiguration branchConfiguration;

    public DefaultSensorContext(InputModule module, Configuration config, Settings mutableSettings, FileSystem fs, ActiveRules activeRules, AnalysisMode analysisMode, SensorStorage sensorStorage, SonarRuntime sonarRuntime, BranchConfiguration branchConfiguration) {
        this.module = module;
        this.config = config;
        this.mutableSettings = mutableSettings;
        this.fs = fs;
        this.activeRules = activeRules;
        this.analysisMode = analysisMode;
        this.sensorStorage = sensorStorage;
        this.sonarRuntime = sonarRuntime;
        this.branchConfiguration = branchConfiguration;
    }

    public Settings settings() {
        return this.mutableSettings;
    }

    public Configuration config() {
        return this.config;
    }

    public FileSystem fileSystem() {
        return this.fs;
    }

    public ActiveRules activeRules() {
        return this.activeRules;
    }

    public InputModule module() {
        return this.module;
    }

    public Version getSonarQubeVersion() {
        return this.sonarRuntime.getApiVersion();
    }

    public SonarRuntime runtime() {
        return this.sonarRuntime;
    }

    public <G extends Serializable> NewMeasure<G> newMeasure() {
        return new DefaultMeasure(this.sensorStorage);
    }

    public NewIssue newIssue() {
        return new DefaultIssue(this.sensorStorage);
    }

    public NewHighlighting newHighlighting() {
        if (this.analysisMode.isIssues()) {
            return NO_OP_NEW_HIGHLIGHTING;
        }
        return new DefaultHighlighting(this.sensorStorage);
    }

    public NewSymbolTable newSymbolTable() {
        if (this.analysisMode.isIssues()) {
            return NO_OP_NEW_SYMBOL_TABLE;
        }
        return new DefaultSymbolTable(this.sensorStorage);
    }

    public NewCoverage newCoverage() {
        if (this.branchConfiguration.isShortLivingBranch()) {
            return NO_OP_NEW_COVERAGE;
        }
        return new DefaultCoverage(this.sensorStorage);
    }

    public NewCpdTokens newCpdTokens() {
        if (this.analysisMode.isIssues() || this.branchConfiguration.isShortLivingBranch()) {
            return NO_OP_NEW_CPD_TOKENS;
        }
        return new DefaultCpdTokens(this.config, this.sensorStorage);
    }

    public NewAnalysisError newAnalysisError() {
        return NO_OP_NEW_ANALYSIS_ERROR;
    }

    public boolean isCancelled() {
        return false;
    }

    public void addContextProperty(String key, String value) {
        this.sensorStorage.storeProperty(key, value);
    }

    public void markForPublishing(InputFile inputFile) {
        DefaultInputFile file = (DefaultInputFile)inputFile;
        file.setPublished(true);
    }
}

