/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.source;

import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.stream.StreamSupport;
import org.sonar.api.batch.Phase;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.measure.Metric;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.coverage.CoverageType;
import org.sonar.api.batch.sensor.coverage.NewCoverage;
import org.sonar.api.batch.sensor.measure.internal.DefaultMeasure;
import org.sonar.api.utils.KeyValueFormat;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.scanner.scan.measure.MeasureCache;

@Phase(name=Phase.Name.POST)
public final class ZeroCoverageSensor
implements Sensor {
    private final MeasureCache measureCache;

    public ZeroCoverageSensor(MeasureCache measureCache) {
        this.measureCache = measureCache;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.name("Zero Coverage Sensor").global();
    }

    public void execute(SensorContext context) {
        FileSystem fs = context.fileSystem();
        for (InputFile f : fs.inputFiles(fs.predicates().hasType(InputFile.Type.MAIN))) {
            DefaultMeasure<?> execLines;
            if (((DefaultInputFile)f).isExcludedForCoverage() || this.isCoverageMeasuresAlreadyDefined(f) || (execLines = this.measureCache.byMetric(f.key(), "executable_lines_data")) == null) continue;
            ZeroCoverageSensor.storeZeroCoverageForEachExecutableLine(context, f, execLines);
        }
    }

    private static void storeZeroCoverageForEachExecutableLine(SensorContext context, InputFile f, DefaultMeasure<String> execLines) {
        NewCoverage newCoverage = context.newCoverage().onFile(f);
        Map lineMeasures = KeyValueFormat.parseIntInt((String)((String)((Object)execLines.value())));
        for (Map.Entry lineMeasure : lineMeasures.entrySet()) {
            int lineIdx = (Integer)lineMeasure.getKey();
            if (lineIdx > f.lines() || (Integer)lineMeasure.getValue() <= 0) continue;
            newCoverage.lineHits(lineIdx, 0);
        }
        newCoverage.save();
    }

    private boolean isCoverageMeasuresAlreadyDefined(InputFile f) {
        Set allCoverageMetricKeys;
        Set metricKeys = (Set)StreamSupport.stream(this.measureCache.byComponentKey(f.key()).spliterator(), false).map(m -> m.metric().key()).collect(MoreCollectors.toSet());
        return !Sets.intersection((Set)metricKeys, (Set)(allCoverageMetricKeys = (Set)CoverageType.UNIT.allMetrics().stream().map(Metric::key).collect(MoreCollectors.toSet()))).isEmpty();
    }
}

