/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.storage;

import com.persistit.Exchange;
import com.persistit.Key;
import com.persistit.KeyFilter;
import com.persistit.exception.PersistitException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.builder.ToStringBuilder;

public class Storage<V> {
    private final String name;
    private final Exchange exchange;

    Storage(String name, Exchange exchange) {
        this.name = name;
        this.exchange = exchange;
    }

    public Storage<V> put(Object key, V value) {
        this.resetKey(key);
        return this.doPut(value);
    }

    public Storage<V> put(Object firstKey, Object secondKey, V value) {
        this.resetKey(firstKey, secondKey);
        return this.doPut(value);
    }

    public Storage<V> put(Object firstKey, Object secondKey, Object thirdKey, V value) {
        this.resetKey(firstKey, secondKey, thirdKey);
        return this.doPut(value);
    }

    public Storage<V> put(Object[] key, V value) {
        this.resetKey(key);
        return this.doPut(value);
    }

    private Storage<V> doPut(V value) {
        try {
            this.exchange.getValue().put(value);
            this.exchange.store();
            return this;
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to put element in the storage '" + this.name + "'", e);
        }
    }

    public V get(Object key) {
        this.resetKey(key);
        return this.doGet();
    }

    @CheckForNull
    public V get(Object firstKey, Object secondKey) {
        this.resetKey(firstKey, secondKey);
        return this.doGet();
    }

    @CheckForNull
    public V get(Object firstKey, Object secondKey, Object thirdKey) {
        this.resetKey(firstKey, secondKey, thirdKey);
        return this.doGet();
    }

    @CheckForNull
    public V get(Object[] key) {
        this.resetKey(key);
        return this.doGet();
    }

    @CheckForNull
    private V doGet() {
        try {
            this.exchange.fetch();
            if (!this.exchange.getValue().isDefined()) {
                return null;
            }
            return (V)this.exchange.getValue().get();
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to get element from cache " + this.name, e);
        }
    }

    public boolean containsKey(Object key) {
        this.resetKey(key);
        return this.doContainsKey();
    }

    public boolean containsKey(Object firstKey, Object secondKey) {
        this.resetKey(firstKey, secondKey);
        return this.doContainsKey();
    }

    public boolean containsKey(Object firstKey, Object secondKey, Object thirdKey) {
        this.resetKey(firstKey, secondKey, thirdKey);
        return this.doContainsKey();
    }

    public boolean containsKey(Object[] key) {
        this.resetKey(key);
        return this.doContainsKey();
    }

    private boolean doContainsKey() {
        try {
            this.exchange.fetch();
            return this.exchange.isValueDefined();
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to check if element is in cache " + this.name, e);
        }
    }

    public boolean remove(Object key) {
        this.resetKey(key);
        return this.doRemove();
    }

    public boolean remove(Object firstKey, Object secondKey) {
        this.resetKey(firstKey, secondKey);
        return this.doRemove();
    }

    public boolean remove(Object firstKey, Object secondKey, Object thirdKey) {
        this.resetKey(firstKey, secondKey, thirdKey);
        return this.doRemove();
    }

    public boolean remove(Object[] key) {
        this.resetKey(key);
        return this.doRemove();
    }

    private boolean doRemove() {
        try {
            return this.exchange.remove();
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to get element from cache " + this.name, e);
        }
    }

    public Storage<V> clear(Object key) {
        this.resetKey(key);
        return this.doClear();
    }

    public Storage<V> clear(Object firstKey, Object secondKey) {
        this.resetKey(firstKey, secondKey);
        return this.doClear();
    }

    public Storage<V> clear(Object firstKey, Object secondKey, Object thirdKey) {
        this.resetKey(firstKey, secondKey, thirdKey);
        return this.doClear();
    }

    public Storage<V> clear(Object[] key) {
        this.resetKey(key);
        return this.doClear();
    }

    private Storage<V> doClear() {
        try {
            Key to = new Key(this.exchange.getKey());
            to.append((Object)Key.AFTER);
            this.exchange.removeKeyRange(this.exchange.getKey(), to);
            return this;
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to clear values from cache " + this.name, e);
        }
    }

    public void clear() {
        try {
            this.exchange.clear();
            this.exchange.removeAll();
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to clear cache", e);
        }
    }

    public Set keySet(Object key) {
        try {
            LinkedHashSet<Object> keys = new LinkedHashSet<Object>();
            this.exchange.clear();
            Exchange iteratorExchange = new Exchange(this.exchange);
            iteratorExchange.append(key);
            iteratorExchange.append((Object)Key.BEFORE);
            while (iteratorExchange.next(false)) {
                keys.add(iteratorExchange.getKey().indexTo(-1).decode());
            }
            return keys;
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to get keys from cache " + this.name, e);
        }
    }

    public Set keySet(Object firstKey, Object secondKey) {
        try {
            LinkedHashSet<Object> keys = new LinkedHashSet<Object>();
            this.exchange.clear();
            Exchange iteratorExchange = new Exchange(this.exchange);
            iteratorExchange.append(firstKey);
            iteratorExchange.append(secondKey);
            iteratorExchange.append((Object)Key.BEFORE);
            while (iteratorExchange.next(false)) {
                keys.add(iteratorExchange.getKey().indexTo(-1).decode());
            }
            return keys;
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to get keys from cache " + this.name, e);
        }
    }

    public Set<Object> keySet() {
        try {
            LinkedHashSet<Object> keys = new LinkedHashSet<Object>();
            this.exchange.clear();
            Exchange iteratorExchange = new Exchange(this.exchange);
            iteratorExchange.append((Object)Key.BEFORE);
            while (iteratorExchange.next(false)) {
                keys.add(iteratorExchange.getKey().indexTo(-1).decode());
            }
            return keys;
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to get keys from cache " + this.name, e);
        }
    }

    public Iterable<V> values(Object firstKey, Object secondKey) {
        return new ValueIterable(this.exchange, new Object[]{firstKey, secondKey});
    }

    public Iterable<V> values(Object firstKey) {
        return new ValueIterable(this.exchange, new Object[]{firstKey});
    }

    public Iterable<V> values() {
        return new ValueIterable(this.exchange, new Object[0]);
    }

    public Iterable<Entry<V>> entries() {
        return new EntryIterable(this.exchange, new Object[0]);
    }

    public Iterable<Entry<V>> entries(Object firstKey) {
        return new EntryIterable(this.exchange, new Object[]{firstKey});
    }

    private void resetKey(Object key) {
        this.exchange.clear();
        this.exchange.append(key);
    }

    private void resetKey(Object first, Object second) {
        this.exchange.clear();
        this.exchange.append(first).append(second);
    }

    private void resetKey(Object first, Object second, Object third) {
        this.exchange.clear();
        this.exchange.append(first).append(second).append(third);
    }

    private void resetKey(Object[] keys) {
        this.exchange.clear();
        for (Object o : keys) {
            this.exchange.append(o);
        }
    }

    public static class Entry<V> {
        private final Object[] key;
        private final V value;

        Entry(Object[] key, V value) {
            this.key = key;
            this.value = value;
        }

        public Object[] key() {
            return this.key;
        }

        public V value() {
            return this.value;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }
    }

    private static class EntryIterator<T>
    implements Iterator<Entry<T>> {
        private final Exchange exchange;
        private final KeyFilter keyFilter;

        private EntryIterator(Exchange exchange, KeyFilter keyFilter) {
            this.exchange = exchange;
            this.keyFilter = keyFilter;
        }

        @Override
        public boolean hasNext() {
            try {
                return this.exchange.hasNext(this.keyFilter);
            }
            catch (PersistitException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public Entry<T> next() {
            try {
                this.exchange.next(this.keyFilter);
            }
            catch (PersistitException e) {
                throw new IllegalStateException(e);
            }
            if (this.exchange.getValue().isDefined()) {
                Object value = this.exchange.getValue().get();
                Key key = this.exchange.getKey();
                Object[] array = new Object[key.getDepth()];
                for (int i = 0; i < key.getDepth(); ++i) {
                    array[i] = key.indexTo(i - key.getDepth()).decode();
                }
                return new Entry<Object>(array, value);
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Removing an item is not supported");
        }
    }

    private static class EntryIterable<T>
    implements Iterable<Entry<T>> {
        private final Exchange originExchange;
        private final Object[] keys;

        private EntryIterable(Exchange originExchange, Object ... keys) {
            this.originExchange = originExchange;
            this.keys = keys;
        }

        @Override
        public Iterator<Entry<T>> iterator() {
            this.originExchange.clear();
            KeyFilter filter = new KeyFilter();
            for (Object key : this.keys) {
                this.originExchange.append(key);
                filter = filter.append(KeyFilter.simpleTerm((Object)key));
            }
            this.originExchange.append((Object)Key.BEFORE);
            Exchange iteratorExchange = new Exchange(this.originExchange);
            return new EntryIterator(iteratorExchange, filter);
        }
    }

    private static class ValueIterator<T>
    implements Iterator<T> {
        private final Exchange exchange;
        private final KeyFilter keyFilter;

        private ValueIterator(Exchange exchange, KeyFilter keyFilter) {
            this.exchange = exchange;
            this.keyFilter = keyFilter;
        }

        @Override
        public boolean hasNext() {
            try {
                return this.exchange.hasNext(this.keyFilter);
            }
            catch (PersistitException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public T next() {
            try {
                this.exchange.next(this.keyFilter);
            }
            catch (PersistitException e) {
                throw new IllegalStateException(e);
            }
            if (this.exchange.getValue().isDefined()) {
                return (T)this.exchange.getValue().get();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Removing an item is not supported");
        }
    }

    private static class ValueIterable<T>
    implements Iterable<T> {
        private final Exchange originExchange;
        private final Object[] keys;

        private ValueIterable(Exchange originExchange, Object ... keys) {
            this.originExchange = originExchange;
            this.keys = keys;
        }

        @Override
        public Iterator<T> iterator() {
            this.originExchange.clear();
            KeyFilter filter = new KeyFilter();
            for (Object key : this.keys) {
                this.originExchange.append(key);
                filter = filter.append(KeyFilter.simpleTerm((Object)key));
            }
            this.originExchange.append((Object)Key.BEFORE);
            Exchange iteratorExchange = new Exchange(this.originExchange);
            return new ValueIterator(iteratorExchange, filter);
        }
    }
}

