/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.task;

import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.sonar.api.batch.InstantiationStrategy;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.task.TaskDefinition;

@ScannerSide
@InstantiationStrategy(value="PER_TASK")
public class Tasks {
    private final SortedMap<String, TaskDefinition> byKey;

    public Tasks(TaskDefinition[] definitions) {
        TreeMap map = Maps.newTreeMap();
        for (TaskDefinition definition : definitions) {
            if (map.containsKey(definition.key())) {
                throw new IllegalStateException("Task '" + definition.key() + "' is declared twice");
            }
            map.put(definition.key(), definition);
        }
        this.byKey = ImmutableSortedMap.copyOf((Map)map);
    }

    public TaskDefinition definition(String taskKey) {
        return (TaskDefinition)this.byKey.get(taskKey);
    }

    public Collection<TaskDefinition> definitions() {
        return this.byKey.values();
    }

    public void start() {
        this.checkDuplicatedClasses();
    }

    private void checkDuplicatedClasses() {
        HashMap byClass = Maps.newHashMap();
        for (TaskDefinition def : this.definitions()) {
            TaskDefinition other = (TaskDefinition)byClass.get(def.taskClass());
            if (other == null) {
                byClass.put(def.taskClass(), def);
                continue;
            }
            throw new IllegalStateException("Task '" + def.taskClass().getName() + "' is defined twice: first by '" + other.key() + "' and then by '" + def.key() + "'");
        }
    }
}

