/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws.client.component;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

public class SearchProjectsRequest {
    public static final int MAX_PAGE_SIZE = 500;
    public static final int DEFAULT_PAGE_SIZE = 100;
    private final int page;
    private final int pageSize;
    private final String organization;
    private final String filter;
    private final List<String> facets;
    private final String sort;
    private final Boolean asc;
    private final List<String> additionalFields;

    private SearchProjectsRequest(Builder builder) {
        this.page = builder.page;
        this.pageSize = builder.pageSize;
        this.organization = builder.organization;
        this.filter = builder.filter;
        this.facets = builder.facets;
        this.sort = builder.sort;
        this.asc = builder.asc;
        this.additionalFields = builder.additionalFields;
    }

    @CheckForNull
    public String getOrganization() {
        return this.organization;
    }

    @CheckForNull
    public String getFilter() {
        return this.filter;
    }

    public List<String> getFacets() {
        return this.facets;
    }

    @CheckForNull
    public String getSort() {
        return this.sort;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getPage() {
        return this.page;
    }

    @CheckForNull
    public Boolean getAsc() {
        return this.asc;
    }

    public List<String> getAdditionalFields() {
        return this.additionalFields;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String organization;
        private Integer page;
        private Integer pageSize;
        private String filter;
        private List<String> facets = new ArrayList<String>();
        private String sort;
        private Boolean asc;
        private List<String> additionalFields = new ArrayList<String>();

        private Builder() {
        }

        public Builder setOrganization(@Nullable String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setFilter(@Nullable String filter) {
            this.filter = filter;
            return this;
        }

        public Builder setFacets(List<String> facets) {
            this.facets = Objects.requireNonNull(facets);
            return this;
        }

        public Builder setPage(int page) {
            this.page = page;
            return this;
        }

        public Builder setPageSize(int pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder setSort(@Nullable String sort) {
            this.sort = sort;
            return this;
        }

        public Builder setAsc(boolean asc) {
            this.asc = asc;
            return this;
        }

        public Builder setAdditionalFields(List<String> additionalFields) {
            this.additionalFields = Objects.requireNonNull(additionalFields, "additional fields cannot be null");
            return this;
        }

        public SearchProjectsRequest build() {
            if (this.page == null) {
                this.page = 1;
            }
            if (this.pageSize == null) {
                this.pageSize = 100;
            }
            Preconditions.checkArgument((this.pageSize <= 500 ? 1 : 0) != 0, (String)"Page size must not be greater than %s", (Object[])new Object[]{500});
            return new SearchProjectsRequest(this);
        }
    }
}

