/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws.client.issue;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

public class BulkChangeRequest {
    private final List<String> issues;
    private final String assign;
    private final String setSeverity;
    private final String setType;
    private final String doTransition;
    private final List<String> addTags;
    private final List<String> removeTags;
    private final String comment;
    private final Boolean sendNotifications;

    private BulkChangeRequest(Builder builder) {
        this.issues = builder.issues;
        this.assign = builder.assign;
        this.setSeverity = builder.setSeverity;
        this.setType = builder.setType;
        this.doTransition = builder.doTransition;
        this.addTags = builder.addTags;
        this.removeTags = builder.removeTags;
        this.comment = builder.comment;
        this.sendNotifications = builder.sendNotifications;
    }

    public List<String> getIssues() {
        return this.issues;
    }

    @CheckForNull
    public String getAssign() {
        return this.assign;
    }

    @CheckForNull
    public String getSetSeverity() {
        return this.setSeverity;
    }

    @CheckForNull
    public String getSetType() {
        return this.setType;
    }

    @CheckForNull
    public String getDoTransition() {
        return this.doTransition;
    }

    public List<String> getAddTags() {
        return this.addTags;
    }

    public List<String> getRemoveTags() {
        return this.removeTags;
    }

    @CheckForNull
    public String getComment() {
        return this.comment;
    }

    @CheckForNull
    public Boolean getSendNotifications() {
        return this.sendNotifications;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<String> issues;
        private String assign;
        private String setSeverity;
        private String setType;
        private String doTransition;
        private List<String> addTags = Lists.newArrayList();
        private List<String> removeTags = Lists.newArrayList();
        private String comment;
        private Boolean sendNotifications;

        public Builder setIssues(List<String> issues) {
            this.issues = issues;
            return this;
        }

        public Builder setAssign(@Nullable String assign) {
            this.assign = assign;
            return this;
        }

        public Builder setSetSeverity(@Nullable String setSeverity) {
            this.setSeverity = setSeverity;
            return this;
        }

        public Builder setSetType(@Nullable String setType) {
            this.setType = setType;
            return this;
        }

        public Builder setDoTransition(@Nullable String doTransition) {
            this.doTransition = doTransition;
            return this;
        }

        public Builder setAddTags(List<String> addTags) {
            this.addTags = Objects.requireNonNull(addTags);
            return this;
        }

        public Builder setRemoveTags(List<String> removeTags) {
            this.removeTags = Objects.requireNonNull(removeTags);
            return this;
        }

        public Builder setComment(@Nullable String comment) {
            this.comment = comment;
            return this;
        }

        public Builder setSendNotifications(@Nullable Boolean sendNotifications) {
            this.sendNotifications = sendNotifications;
            return this;
        }

        public BulkChangeRequest build() {
            Preconditions.checkArgument((this.issues != null && !this.issues.isEmpty() ? 1 : 0) != 0, (Object)"Issue keys must be provided");
            return new BulkChangeRequest(this);
        }
    }
}

