/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws.client.issue;

import java.util.Arrays;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonarqube.ws.Issues;
import org.sonarqube.ws.client.BaseRequest;
import org.sonarqube.ws.client.BaseService;
import org.sonarqube.ws.client.GetRequest;
import org.sonarqube.ws.client.PostRequest;
import org.sonarqube.ws.client.WsConnector;
import org.sonarqube.ws.client.WsRequest;
import org.sonarqube.ws.client.WsResponse;
import org.sonarqube.ws.client.issue.AddCommentRequest;
import org.sonarqube.ws.client.issue.AssignRequest;
import org.sonarqube.ws.client.issue.BulkChangeRequest;
import org.sonarqube.ws.client.issue.DoTransitionRequest;
import org.sonarqube.ws.client.issue.EditCommentRequest;
import org.sonarqube.ws.client.issue.SearchWsRequest;
import org.sonarqube.ws.client.issue.SetSeverityRequest;
import org.sonarqube.ws.client.issue.SetTypeRequest;

public class IssuesService
extends BaseService {
    public IssuesService(WsConnector wsConnector) {
        super(wsConnector, "api/issues");
    }

    public Issues.Operation addComment(AddCommentRequest request) {
        return this.call((BaseRequest)((PostRequest)new PostRequest(this.path("add_comment")).setParam("issue", request.getIssue())).setParam("text", request.getText()), Issues.Operation.parser());
    }

    public Issues.Operation assign(AssignRequest request) {
        return this.call((BaseRequest)((PostRequest)new PostRequest(this.path("assign")).setParam("issue", request.getIssue())).setParam("assignee", request.getAssignee()), Issues.Operation.parser());
    }

    public Issues.BulkChangeWsResponse bulkChange(BulkChangeRequest request) {
        return this.call((BaseRequest)((PostRequest)((PostRequest)((PostRequest)((PostRequest)((PostRequest)((PostRequest)((PostRequest)((PostRequest)new PostRequest(this.path("bulk_change")).setParam("issues", IssuesService.inlineMultipleParamValue(request.getIssues()))).setParam("assign", request.getAssign())).setParam("set_severity", request.getSetSeverity())).setParam("set_type", request.getSetType())).setParam("do_transition", request.getDoTransition())).setParam("add_tags", IssuesService.inlineMultipleParamValue(request.getAddTags()))).setParam("remove_tags", IssuesService.inlineMultipleParamValue(request.getRemoveTags()))).setParam("comment", request.getComment())).setParam("sendNotifications", request.getSendNotifications()), Issues.BulkChangeWsResponse.parser());
    }

    public Issues.ChangelogWsResponse changelog(String issueKey) {
        return this.call((BaseRequest)new GetRequest(this.path("changelog")).setParam("issue", issueKey), Issues.ChangelogWsResponse.parser());
    }

    public Issues.Operation doTransition(DoTransitionRequest request) {
        return this.call((BaseRequest)((PostRequest)new PostRequest(this.path("do_transition")).setParam("issue", request.getIssue())).setParam("transition", request.getTransition()), Issues.Operation.parser());
    }

    public Issues.Operation deleteComment(String commentKey) {
        return this.call((BaseRequest)new PostRequest(this.path("delete_comment")).setParam("comment", commentKey), Issues.Operation.parser());
    }

    public Issues.Operation editComment(EditCommentRequest request) {
        return this.call((BaseRequest)((PostRequest)new PostRequest(this.path("edit_comment")).setParam("comment", request.getComment())).setParam("text", request.getText()), Issues.Operation.parser());
    }

    public Issues.SearchWsResponse search(SearchWsRequest request) {
        return this.call((BaseRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)new GetRequest(this.path("search")).setParam("actionPlans", IssuesService.inlineMultipleParamValue(request.getActionPlans()))).setParam("additionalFields", IssuesService.inlineMultipleParamValue(request.getAdditionalFields()))).setParam("asc", request.getAsc())).setParam("assigned", request.getAssigned())).setParam("assignees", IssuesService.inlineMultipleParamValue(request.getAssignees()))).setParam("authors", IssuesService.inlineMultipleParamValue(request.getAuthors()))).setParam("componentKeys", IssuesService.inlineMultipleParamValue(request.getComponentKeys()))).setParam("componentRootUuids", IssuesService.inlineMultipleParamValue(request.getComponentRootUuids()))).setParam("componentRoots", IssuesService.inlineMultipleParamValue(request.getComponentRoots()))).setParam("componentUuids", IssuesService.inlineMultipleParamValue(request.getComponentUuids()))).setParam("components", IssuesService.inlineMultipleParamValue(request.getComponents()))).setParam("createdAfter", request.getCreatedAfter())).setParam("createdAt", request.getCreatedAt())).setParam("createdBefore", request.getCreatedBefore())).setParam("createdInLast", request.getCreatedInLast())).setParam("directories", IssuesService.inlineMultipleParamValue(request.getDirectories()))).setParam("branch", request.getBranch())).setParam("facetMode", request.getFacetMode())).setParam("facets", IssuesService.inlineMultipleParamValue(request.getFacets()))).setParam("fileUuids", IssuesService.inlineMultipleParamValue(request.getFileUuids()))).setParam("issues", IssuesService.inlineMultipleParamValue(request.getIssues()))).setParam("languages", IssuesService.inlineMultipleParamValue(request.getLanguages()))).setParam("moduleUuids", IssuesService.inlineMultipleParamValue(request.getModuleUuids()))).setParam("onComponentOnly", request.getOnComponentOnly())).setParam("p", request.getPage())).setParam("ps", request.getPageSize())).setParam("projectKeys", IssuesService.inlineMultipleParamValue(request.getProjectKeys()))).setParam("projectUuids", IssuesService.inlineMultipleParamValue(request.getProjectUuids()))).setParam("projects", IssuesService.inlineMultipleParamValue(request.getProjects()))).setParam("resolutions", IssuesService.inlineMultipleParamValue(request.getResolutions()))).setParam("resolved", request.getResolved())).setParam("rules", IssuesService.inlineMultipleParamValue(request.getRules()))).setParam("s", request.getSort())).setParam("severities", IssuesService.inlineMultipleParamValue(request.getSeverities()))).setParam("sinceLeakPeriod", request.getSinceLeakPeriod())).setParam("statuses", IssuesService.inlineMultipleParamValue(request.getStatuses()))).setParam("tags", IssuesService.inlineMultipleParamValue(request.getTags()))).setParam("types", IssuesService.inlineMultipleParamValue(request.getTypes())), Issues.SearchWsResponse.parser());
    }

    public Issues.Operation setSeverity(SetSeverityRequest request) {
        return this.call((BaseRequest)((PostRequest)new PostRequest(this.path("set_severity")).setParam("issue", request.getIssue())).setParam("severity", request.getSeverity()), Issues.Operation.parser());
    }

    public Issues.Operation setType(SetTypeRequest request) {
        return this.call((BaseRequest)((PostRequest)new PostRequest(this.path("set_type")).setParam("issue", request.getIssue())).setParam("type", request.getType()), Issues.Operation.parser());
    }

    public Issues.Operation setTags(String issue, String ... tags) {
        return this.call((BaseRequest)((PostRequest)new PostRequest(this.path("set_tags")).setParam("issue", issue)).setParam("tags", Arrays.stream(tags).collect(Collectors.joining(","))), Issues.Operation.parser());
    }

    public WsResponse getTags(@Nullable String organization) {
        return this.call((WsRequest)new PostRequest(this.path("tags")).setParam("organization", organization));
    }
}

