/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws.client.measure;

import com.google.common.base.Preconditions;
import java.util.List;

public class SearchRequest {
    public static final int MAX_NB_PROJECTS = 100;
    private final List<String> metricKeys;
    private final List<String> projectKeys;

    public SearchRequest(Builder builder) {
        this.metricKeys = builder.metricKeys;
        this.projectKeys = builder.projectKeys;
    }

    public List<String> getMetricKeys() {
        return this.metricKeys;
    }

    public List<String> getProjectKeys() {
        return this.projectKeys;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<String> metricKeys;
        private List<String> projectKeys;

        private Builder() {
        }

        public Builder setMetricKeys(List<String> metricKeys) {
            this.metricKeys = metricKeys;
            return this;
        }

        public Builder setProjectKeys(List<String> projectKeys) {
            this.projectKeys = projectKeys;
            return this;
        }

        public SearchRequest build() {
            Preconditions.checkArgument((this.metricKeys != null && !this.metricKeys.isEmpty() ? 1 : 0) != 0, (Object)"Metric keys must be provided");
            Preconditions.checkArgument((this.projectKeys != null && !this.projectKeys.isEmpty() ? 1 : 0) != 0, (Object)"Project keys must be provided");
            int nbComponents = this.projectKeys.size();
            Preconditions.checkArgument((nbComponents <= 100 ? 1 : 0) != 0, (String)"%s projects provided, more than maximum authorized (%s)", (Object[])new Object[]{nbComponents, 100});
            return new SearchRequest(this);
        }
    }
}

