/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws.client.notification;

import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

public class AddRequest {
    private final String type;
    private final String channel;
    private final String project;
    private final String login;

    private AddRequest(Builder builder) {
        this.channel = builder.channel;
        this.type = builder.type;
        this.project = builder.project;
        this.login = builder.login;
    }

    public String getType() {
        return this.type;
    }

    @CheckForNull
    public String getChannel() {
        return this.channel;
    }

    @CheckForNull
    public String getProject() {
        return this.project;
    }

    @CheckForNull
    public String getLogin() {
        return this.login;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String type;
        private String channel;
        private String project;
        private String login;

        private Builder() {
        }

        public Builder setType(String type) {
            this.type = type;
            return this;
        }

        public Builder setChannel(@Nullable String channel) {
            this.channel = channel;
            return this;
        }

        public Builder setProject(@Nullable String project) {
            this.project = project;
            return this;
        }

        public Builder setLogin(@Nullable String login) {
            this.login = login;
            return this;
        }

        public AddRequest build() {
            Objects.requireNonNull(this.type, "Notification is required");
            return new AddRequest(this);
        }
    }
}

