/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws.client.organization;

import java.util.Objects;
import org.sonarqube.ws.Organizations;
import org.sonarqube.ws.client.BaseService;
import org.sonarqube.ws.client.GetRequest;
import org.sonarqube.ws.client.PostRequest;
import org.sonarqube.ws.client.WsConnector;
import org.sonarqube.ws.client.organization.CreateWsRequest;
import org.sonarqube.ws.client.organization.SearchMembersWsRequest;
import org.sonarqube.ws.client.organization.SearchWsRequest;
import org.sonarqube.ws.client.organization.UpdateProjectVisibilityWsRequest;
import org.sonarqube.ws.client.organization.UpdateWsRequest;

public class OrganizationService
extends BaseService {
    public OrganizationService(WsConnector wsConnector) {
        super(wsConnector, "api/organizations");
    }

    public Organizations.SearchWsResponse search(SearchWsRequest request) {
        GetRequest get = (GetRequest)((GetRequest)((GetRequest)new GetRequest(this.path("search")).setParam("organizations", OrganizationService.inlineMultipleParamValue(request.getOrganizations()))).setParam("p", request.getPage())).setParam("ps", request.getPageSize());
        return this.call(get, Organizations.SearchWsResponse.parser());
    }

    public Organizations.CreateWsResponse create(CreateWsRequest request) {
        PostRequest post = (PostRequest)((PostRequest)((PostRequest)((PostRequest)((PostRequest)new PostRequest(this.path("create")).setParam("name", request.getName())).setParam("key", request.getKey())).setParam("description", request.getDescription())).setParam("url", request.getUrl())).setParam("avatar", request.getAvatar());
        return this.call(post, Organizations.CreateWsResponse.parser());
    }

    public Organizations.UpdateWsResponse update(UpdateWsRequest request) {
        PostRequest post = (PostRequest)((PostRequest)((PostRequest)((PostRequest)((PostRequest)new PostRequest(this.path("update")).setParam("key", request.getKey())).setParam("name", request.getName())).setParam("description", request.getDescription())).setParam("url", request.getUrl())).setParam("avatar", request.getAvatar());
        return this.call(post, Organizations.UpdateWsResponse.parser());
    }

    public void delete(String key) {
        PostRequest post = (PostRequest)new PostRequest(this.path("delete")).setParam("organization", key);
        this.call(post).failIfNotSuccessful();
    }

    public Organizations.SearchMembersWsResponse searchMembers(SearchMembersWsRequest request) {
        GetRequest get = (GetRequest)((GetRequest)((GetRequest)((GetRequest)((GetRequest)new GetRequest(this.path("search_members")).setParam("organization", request.getOrganization())).setParam("selected", request.getSelected())).setParam("q", request.getQuery())).setParam("p", request.getPage())).setParam("ps", request.getPageSize());
        return this.call(get, Organizations.SearchMembersWsResponse.parser());
    }

    public Organizations.AddMemberWsResponse addMember(String organizationKey, String login) {
        PostRequest post = (PostRequest)((PostRequest)new PostRequest(this.path("add_member")).setParam("organization", Objects.requireNonNull(organizationKey))).setParam("login", Objects.requireNonNull(login));
        return this.call(post, Organizations.AddMemberWsResponse.parser());
    }

    public void removeMember(String organizationKey, String login) {
        PostRequest post = (PostRequest)((PostRequest)new PostRequest(this.path("remove_member")).setParam("organization", Objects.requireNonNull(organizationKey))).setParam("login", Objects.requireNonNull(login));
        this.call(post);
    }

    public void updateProjectVisibility(UpdateProjectVisibilityWsRequest request) {
        PostRequest post = (PostRequest)((PostRequest)new PostRequest(this.path("update_project_visibility")).setParam("organization", request.getOrganization())).setParam("projectVisibility", request.getProjectVisibility());
        this.call(post, Organizations.UpdateWsResponse.parser());
    }
}

