/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.ws.client.organization;

import java.util.Arrays;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class SearchWsRequest {
    private final Integer page;
    private final Integer pageSize;
    private final List<String> organizations;

    private SearchWsRequest(Builder builder) {
        this.page = builder.page;
        this.pageSize = builder.pageSize;
        this.organizations = builder.organizations;
    }

    @CheckForNull
    public Integer getPageSize() {
        return this.pageSize;
    }

    @CheckForNull
    public Integer getPage() {
        return this.page;
    }

    @CheckForNull
    public List<String> getOrganizations() {
        return this.organizations;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer page;
        private Integer pageSize;
        private List<String> organizations;

        public Builder setPage(@Nullable Integer page) {
            this.page = page;
            return this;
        }

        public Builder setPageSize(@Nullable Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder setOrganizations(String ... organizations) {
            this.organizations = Arrays.asList(organizations);
            return this;
        }

        public SearchWsRequest build() {
            return new SearchWsRequest(this);
        }
    }
}

